/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda;

import com.amazonaws.services.lambda.AWSLambda;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.lambda.LambdaComponentVerifierExtension;
import org.apache.camel.component.aws.lambda.LambdaConfiguration;
import org.apache.camel.component.aws.lambda.LambdaEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-lambda")
public class LambdaComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private LambdaConfiguration configuration;

    public LambdaComponent() {
        this(null);
    }

    public LambdaComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new LambdaComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        LambdaConfiguration configuration = this.configuration != null ? this.configuration.copy() : new LambdaConfiguration();
        LambdaEndpoint endpoint = new LambdaEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setFunction(remaining);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAwsLambdaClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("accessKey/secretKey or awsLambdaClient must be specified");
        }
        return endpoint;
    }

    public LambdaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(LambdaConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(LambdaConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AWSLambda.class);
        if (clients.size() == 1) {
            configuration.setAwsLambdaClient((AWSLambda)clients.stream().findFirst().get());
        }
    }
}

