/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.mq;

import com.amazonaws.services.mq.AmazonMQ;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.mq.MQComponentVerifierExtension;
import org.apache.camel.component.aws.mq.MQConfiguration;
import org.apache.camel.component.aws.mq.MQEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-mq")
public class MQComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private MQConfiguration configuration;

    public MQComponent() {
        this(null);
    }

    public MQComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MQComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MQConfiguration configuration = this.configuration != null ? this.configuration.copy() : new MQConfiguration();
        MQEndpoint endpoint = new MQEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonMqClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonMQClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MQConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MQConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(MQConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonMQ.class);
        if (clients.size() == 1) {
            configuration.setAmazonMqClient((AmazonMQ)clients.stream().findFirst().get());
        }
    }
}

