/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ddb;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ddb.Ddb2ComponentVerifierExtension;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@org.apache.camel.spi.annotations.Component(value="aws2-ddb")
public class Ddb2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private Ddb2Configuration configuration;

    public Ddb2Component() {
        this(null);
    }

    public Ddb2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Ddb2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        Ddb2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Ddb2Configuration();
        configuration.setTableName(remaining);
        Ddb2Endpoint endpoint = new Ddb2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonDDBClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonDDBClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Ddb2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Ddb2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(Ddb2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(DynamoDbClient.class);
        if (clients.size() == 1) {
            configuration.setAmazonDDBClient((DynamoDbClient)clients.stream().findFirst().get());
        }
    }
}

