/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ec2;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.ec2.AWS2EC2ComponentVerifierExtension;
import org.apache.camel.component.aws2.ec2.AWS2EC2Configuration;
import org.apache.camel.component.aws2.ec2.AWS2EC2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.ec2.Ec2Client;

@org.apache.camel.spi.annotations.Component(value="aws2-ec2")
public class AWS2EC2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private AWS2EC2Configuration configuration;

    public AWS2EC2Component() {
        this(null);
    }

    public AWS2EC2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new AWS2EC2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AWS2EC2Configuration configuration = this.configuration != null ? this.configuration.copy() : new AWS2EC2Configuration();
        AWS2EC2Endpoint endpoint = new AWS2EC2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonEc2Client() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonEC2Client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public AWS2EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AWS2EC2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    private void checkAndSetRegistryClient(AWS2EC2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(Ec2Client.class);
        if (clients.size() == 1) {
            configuration.setAmazonEc2Client((Ec2Client)clients.stream().findFirst().get());
        }
    }
}

