/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.commands.AbstractRouteCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.commands.StringEscape;
import org.apache.camel.support.dump.RouteStatDump;
import org.apache.camel.support.dump.StepStatDump;

public class RouteStepCommand
extends AbstractRouteCommand {
    protected static final String HEADER_FORMAT = "%-30s %10s %12s %12s %12s %12s %12s %12s";
    protected static final String OUTPUT_FORMAT = "%-30s %10d %12d %12d %12d %12d %12d %12d";
    private StringEscape stringEscape;
    private volatile String previousCamelContextName;

    public RouteStepCommand(String route, String context) {
        super(route, context);
    }

    public void setStringEscape(StringEscape stringEscape) {
        this.stringEscape = stringEscape;
    }

    @Override
    public void executeOnRoute(CamelController camelController, String contextName, String routeId, PrintStream out, PrintStream err) throws Exception {
        String xml;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RouteStatDump.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.previousCamelContextName == null || !this.previousCamelContextName.equals(contextName)) {
            out.println("");
            out.println(this.stringEscape.unescapeJava("\u001b[1mStep\u001b[0m"));
            out.println(this.stringEscape.unescapeJava("\tCamel Context: " + contextName));
            out.println(String.format(HEADER_FORMAT, "Id", "Count", "Last (ms)", "Delta (ms)", "Mean (ms)", "Min (ms)", "Max (ms)", "Total (ms)"));
        }
        if ((xml = camelController.getStepStatsAsXml(routeId, contextName, true)) != null) {
            RouteStatDump route = (RouteStatDump)unmarshaller.unmarshal((Reader)new StringReader(xml));
            long count = route.getExchangesCompleted() + route.getExchangesFailed();
            out.println(String.format(OUTPUT_FORMAT, route.getId(), count, route.getLastProcessingTime(), route.getDeltaProcessingTime(), route.getMeanProcessingTime(), route.getMinProcessingTime(), route.getMaxProcessingTime(), route.getTotalProcessingTime()));
            for (StepStatDump ss : route.getStepStats()) {
                count = ss.getExchangesCompleted() + ss.getExchangesFailed();
                out.println(String.format(OUTPUT_FORMAT, "  " + ss.getId(), count, ss.getLastProcessingTime(), ss.getDeltaProcessingTime(), ss.getMeanProcessingTime(), ss.getMinProcessingTime(), ss.getMaxProcessingTime(), ss.getTotalProcessingTime()));
            }
        }
        this.previousCamelContextName = contextName;
    }
}

