/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.services.kafka.AWSKafka;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.msk.MSKComponentVerifierExtension;
import org.apache.camel.component.aws.msk.MSKConfiguration;
import org.apache.camel.component.aws.msk.MSKEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-msk")
public class MSKComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private MSKConfiguration configuration;

    public MSKComponent() {
        this(null);
    }

    public MSKComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MSKComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MSKConfiguration configuration = this.configuration != null ? this.configuration.copy() : new MSKConfiguration();
        MSKEndpoint endpoint = new MSKEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getMskClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon msk client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MSKConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MSKConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(MSKConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AWSKafka.class);
        if (clients.size() == 1) {
            configuration.setMskClient((AWSKafka)clients.stream().findFirst().get());
        }
    }
}

