/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="json-gson")
public class GsonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader {
    private Gson gson;
    private Class<?> unmarshalType;
    private Type unmarshalGenericType;
    private List<ExclusionStrategy> exclusionStrategies;
    private LongSerializationPolicy longSerializationPolicy;
    private FieldNamingPolicy fieldNamingPolicy;
    private FieldNamingStrategy fieldNamingStrategy;
    private boolean serializeNulls;
    private boolean prettyPrint;
    private String dateFormatPattern;
    private boolean contentTypeHeader = true;

    public GsonDataFormat() {
        this(Object.class);
    }

    public GsonDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    @Deprecated
    public GsonDataFormat(Class<?> unmarshalType, ExclusionStrategy ... exclusionStrategies) {
        this(null, unmarshalType);
        this.setExclusionStrategies(Arrays.asList(exclusionStrategies));
    }

    public GsonDataFormat(Gson gson, Class<?> unmarshalType) {
        this.gson = gson;
        this.unmarshalType = unmarshalType;
    }

    public GsonDataFormat(Type unmarshalGenericType) {
        this(null, unmarshalGenericType);
    }

    public GsonDataFormat(Gson gson, Type unmarshalGenericType) {
        this.gson = gson;
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public String getDataFormatName() {
        return "json-gson";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, ExchangeHelper.getCharsetName((Exchange)exchange));
             BufferedWriter writer = IOHelper.buffered((Writer)osw);){
            this.gson.toJson(graph, (Appendable)writer);
        }
        if (this.contentTypeHeader) {
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("Content-Type", (Object)"application/json");
            } else {
                exchange.getIn().setHeader("Content-Type", (Object)"application/json");
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doStart() throws Exception {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            if (this.exclusionStrategies != null && !this.exclusionStrategies.isEmpty()) {
                ExclusionStrategy[] strategies = this.exclusionStrategies.toArray(new ExclusionStrategy[this.exclusionStrategies.size()]);
                builder.setExclusionStrategies(strategies);
            }
            if (this.longSerializationPolicy != null) {
                builder.setLongSerializationPolicy(this.longSerializationPolicy);
            }
            if (this.fieldNamingPolicy != null) {
                builder.setFieldNamingPolicy(this.fieldNamingPolicy);
            }
            if (this.fieldNamingStrategy != null) {
                builder.setFieldNamingStrategy(this.fieldNamingStrategy);
            }
            if (this.serializeNulls) {
                builder.serializeNulls();
            }
            if (this.prettyPrint) {
                builder.setPrettyPrinting();
            }
            if (this.dateFormatPattern != null) {
                builder.setDateFormat(this.dateFormatPattern);
            }
            this.gson = builder.create();
        }
    }

    protected void doStop() throws Exception {
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public Type getUnmarshalGenericType() {
        return this.unmarshalType;
    }

    public void setUnmarshalGenericType(Type unmarshalGenericType) {
        this.unmarshalGenericType = unmarshalGenericType;
    }

    public List<ExclusionStrategy> getExclusionStrategies() {
        return this.exclusionStrategies;
    }

    public void setExclusionStrategies(List<ExclusionStrategy> exclusionStrategies) {
        this.exclusionStrategies = exclusionStrategies;
    }

    public LongSerializationPolicy getLongSerializationPolicy() {
        return this.longSerializationPolicy;
    }

    public void setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = longSerializationPolicy;
    }

    public FieldNamingPolicy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }

    public void setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        this.fieldNamingPolicy = fieldNamingPolicy;
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    @Deprecated
    public Boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    @Deprecated
    public void setSerializeNulls(Boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    @Deprecated
    public Boolean getPrettyPrinting() {
        return this.prettyPrint;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Deprecated
    public void setPrettyPrinting(Boolean prettyPrinting) {
        this.prettyPrint = prettyPrinting;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public Gson getGson() {
        return this.gson;
    }
}

