/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponentVerifierExtension;
import org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration;
import org.apache.camel.component.aws.ddbstream.DdbStreamEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="aws-ddbstream")
public class DdbStreamComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private DdbStreamConfiguration configuration;

    public DdbStreamComponent() {
        this(null);
    }

    public DdbStreamComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new DdbStreamComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Table name must be specified.");
        }
        DdbStreamConfiguration configuration = this.configuration != null ? this.configuration.copy() : new DdbStreamConfiguration();
        configuration.setTableName(remaining);
        DdbStreamEndpoint endpoint = new DdbStreamEndpoint(uri, configuration, this);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonDynamoDbStreamsClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonDDBStreamsClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public DdbStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DdbStreamConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(DdbStreamConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonDynamoDBStreams.class);
        if (clients.size() == 1) {
            configuration.setAmazonDynamoDbStreamsClient((AmazonDynamoDBStreams)clients.stream().findFirst().get());
        }
    }
}

