/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.translate;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.translate.Translate2ComponentVerifierExtension;
import org.apache.camel.component.aws2.translate.Translate2Configuration;
import org.apache.camel.component.aws2.translate.Translate2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.translate.TranslateClient;

@org.apache.camel.spi.annotations.Component(value="aws2-translate")
public class Translate2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private Translate2Configuration configuration;

    public Translate2Component() {
        this(null);
    }

    public Translate2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Translate2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Translate2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Translate2Configuration();
        Translate2Endpoint endpoint = new Translate2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getTranslateClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon translate client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Translate2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Translate2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(Translate2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(TranslateClient.class);
        if (clients.size() == 1) {
            configuration.setTranslateClient((TranslateClient)clients.stream().findFirst().get());
        }
    }
}

