/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.influxdb.CamelInfluxDbException;
import org.apache.camel.component.influxdb.InfluxDbEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbProducer.class);
    InfluxDbEndpoint endpoint;
    InfluxDB connection;

    public InfluxDbProducer(InfluxDbEndpoint endpoint) {
        super((Endpoint)endpoint);
        if (ObjectHelper.isEmpty((Object)endpoint.getInfluxDB())) {
            throw new IllegalArgumentException("Can't create a producer when the database connection is null");
        }
        this.connection = endpoint.getInfluxDB();
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String dataBaseName = this.calculateDatabaseName(exchange);
        String retentionPolicy = this.calculateRetentionPolicy(exchange);
        switch (this.endpoint.getOperation()) {
            case "insert": {
                this.doInsert(exchange, dataBaseName, retentionPolicy);
                break;
            }
            case "query": {
                this.doQuery(exchange, dataBaseName, retentionPolicy);
                break;
            }
            case "ping": {
                this.doPing(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation " + this.endpoint.getOperation() + " is not supported");
            }
        }
    }

    private void doInsert(Exchange exchange, String dataBaseName, String retentionPolicy) throws InvalidPayloadException {
        if (!this.endpoint.isBatch()) {
            Point p = (Point)exchange.getIn().getMandatoryBody(Point.class);
            try {
                LOG.debug("Writing point {}", (Object)p.lineProtocol());
                if (!this.connection.databaseExists(dataBaseName)) {
                    LOG.debug("Database {} doesn't exist. Creating it...", (Object)dataBaseName);
                    this.connection.createDatabase(dataBaseName);
                }
                this.connection.write(dataBaseName, retentionPolicy, p);
            }
            catch (Exception ex) {
                exchange.setException((Throwable)new CamelInfluxDbException(ex));
            }
        } else {
            BatchPoints batchPoints = (BatchPoints)exchange.getIn().getMandatoryBody(BatchPoints.class);
            try {
                LOG.debug("Writing BatchPoints {}", (Object)batchPoints.lineProtocol());
                this.connection.write(batchPoints);
            }
            catch (Exception ex) {
                exchange.setException((Throwable)new CamelInfluxDbException(ex));
            }
        }
    }

    private void doQuery(Exchange exchange, String dataBaseName, String retentionPolicy) {
        String query = this.calculateQuery(exchange);
        Query influxdbQuery = new Query(query, dataBaseName);
        QueryResult resultSet = this.connection.query(influxdbQuery);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)resultSet);
    }

    private void doPing(Exchange exchange) {
        Pong result = this.connection.ping();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)result);
    }

    private String calculateRetentionPolicy(Exchange exchange) {
        String retentionPolicy = (String)exchange.getIn().getHeader("camelInfluxDB.RetentionPolicy", String.class);
        if (ObjectHelper.isNotEmpty((Object)retentionPolicy)) {
            return retentionPolicy;
        }
        return this.endpoint.getRetentionPolicy();
    }

    private String calculateDatabaseName(Exchange exchange) {
        String dbName = (String)exchange.getIn().getHeader("camelInfluxDB.databaseName", String.class);
        if (ObjectHelper.isNotEmpty((Object)dbName)) {
            return dbName;
        }
        return this.endpoint.getDatabaseName();
    }

    private String calculateQuery(Exchange exchange) {
        String query = (String)exchange.getIn().getHeader("camelInfluxDB.query", String.class);
        if (ObjectHelper.isNotEmpty((Object)query)) {
            return query;
        }
        query = this.endpoint.getQuery();
        if (ObjectHelper.isEmpty((Object)query)) {
            throw new IllegalArgumentException("The query option must be set if you want to run a query operation");
        }
        return query;
    }
}

