/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.impl.CatalogHelper;

public class DefaultRuntimeProvider
implements RuntimeProvider {
    private static final String COMPONENT_DIR = "org/apache/camel/catalog/components";
    private static final String DATAFORMAT_DIR = "org/apache/camel/catalog/dataformats";
    private static final String LANGUAGE_DIR = "org/apache/camel/catalog/languages";
    private static final String OTHER_DIR = "org/apache/camel/catalog/others";
    private static final String COMPONENTS_CATALOG = "org/apache/camel/catalog/components.properties";
    private static final String DATA_FORMATS_CATALOG = "org/apache/camel/catalog/dataformats.properties";
    private static final String LANGUAGE_CATALOG = "org/apache/camel/catalog/languages.properties";
    private static final String OTHER_CATALOG = "org/apache/camel/catalog/others.properties";
    private CamelCatalog camelCatalog;

    public DefaultRuntimeProvider() {
    }

    public DefaultRuntimeProvider(CamelCatalog camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    @Override
    public CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    @Override
    public void setCamelCatalog(CamelCatalog camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    @Override
    public String getProviderName() {
        return "default";
    }

    @Override
    public String getProviderGroupId() {
        return "org.apache.camel";
    }

    @Override
    public String getProviderArtifactId() {
        return "camel-catalog";
    }

    @Override
    public String getComponentJSonSchemaDirectory() {
        return COMPONENT_DIR;
    }

    @Override
    public String getDataFormatJSonSchemaDirectory() {
        return DATAFORMAT_DIR;
    }

    @Override
    public String getLanguageJSonSchemaDirectory() {
        return LANGUAGE_DIR;
    }

    @Override
    public String getOtherJSonSchemaDirectory() {
        return OTHER_DIR;
    }

    protected String getComponentsCatalog() {
        return COMPONENTS_CATALOG;
    }

    protected String getDataFormatsCatalog() {
        return DATA_FORMATS_CATALOG;
    }

    protected String getLanguageCatalog() {
        return LANGUAGE_CATALOG;
    }

    protected String getOtherCatalog() {
        return OTHER_CATALOG;
    }

    @Override
    public List<String> findComponentNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(this.getComponentsCatalog());
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findDataFormatNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(this.getDataFormatsCatalog());
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findLanguageNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(this.getLanguageCatalog());
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findOtherNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = this.getCamelCatalog().getVersionManager().getResourceAsStream(this.getOtherCatalog());
        if (is != null) {
            try {
                CatalogHelper.loadLines((InputStream)is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }
}

