/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.component.salesforce.SalesforceComponent;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.processor.SalesforceProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSalesforceProcessor
implements SalesforceProcessor {
    protected static final boolean NOT_OPTIONAL = false;
    protected static final boolean IS_OPTIONAL = true;
    protected static final boolean USE_BODY = true;
    protected static final boolean IGNORE_BODY = false;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SalesforceEndpoint endpoint;
    protected final Map<String, Object> endpointConfigMap;
    protected final OperationName operationName;
    protected final SalesforceSession session;
    protected final SalesforceHttpClient httpClient;
    protected final boolean rawPayload;

    public AbstractSalesforceProcessor(SalesforceEndpoint endpoint) {
        this.endpoint = endpoint;
        this.operationName = endpoint.getOperationName();
        this.endpointConfigMap = endpoint.getConfiguration().toValueMap();
        SalesforceComponent component = endpoint.getComponent();
        this.session = component.getSession();
        this.httpClient = endpoint.getConfiguration().getHttpClient();
        this.rawPayload = endpoint.getConfiguration().isRawPayload();
    }

    @Override
    public abstract boolean process(Exchange var1, AsyncCallback var2);

    protected final String getParameter(String propName, Exchange exchange, boolean convertInBody, boolean optional) throws SalesforceException {
        return this.getParameter(propName, exchange, convertInBody, optional, String.class);
    }

    protected final <T> T getParameter(String propName, Exchange exchange, boolean convertInBody, boolean optional, Class<T> parameterClass) throws SalesforceException {
        Message in = exchange.getIn();
        Object propValue = in.getHeader(propName, parameterClass);
        if (propValue == null) {
            if (in.getHeader(propName) != null) {
                throw new IllegalArgumentException("Header " + propName + " could not be converted to type " + parameterClass.getName());
            }
            Object value = this.endpointConfigMap.get(propName);
            if (value == null || parameterClass.isInstance(value)) {
                propValue = parameterClass.cast(value);
            } else {
                try {
                    propValue = exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterClass, value);
                }
                catch (NoTypeConversionAvailableException e) {
                    throw new SalesforceException(e);
                }
            }
        }
        Object object = propValue = propValue == null && convertInBody ? in.getBody(parameterClass) : propValue;
        if (propValue == null && !optional) {
            String msg = "Missing property " + propName + (convertInBody ? ", message body could not be converted to type " + parameterClass.getName() : "");
            throw new SalesforceException(msg, null);
        }
        return (T)propValue;
    }
}

