/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.zookeeper.ZooKeeperComponent;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperConnectionManager;
import org.apache.camel.component.zookeeper.ZooKeeperConsumer;
import org.apache.camel.component.zookeeper.ZooKeeperProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@ManagedResource(description="ZooKeeper Endpoint")
@UriEndpoint(firstVersion="2.9.0", scheme="zookeeper", title="ZooKeeper", syntax="zookeeper:serverUrls/path", label="clustering")
public class ZooKeeperEndpoint
extends DefaultEndpoint {
    @UriParam
    private ZooKeeperConfiguration configuration;
    private ZooKeeperConnectionManager connectionManager;

    public ZooKeeperEndpoint(String uri, ZooKeeperComponent component, ZooKeeperConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.connectionManager = new ZooKeeperConnectionManager(this);
    }

    public Producer createProducer() throws Exception {
        return new ZooKeeperProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ZooKeeperConsumer answer = new ZooKeeperConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void setConfiguration(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }

    public ZooKeeperConfiguration getConfiguration() {
        return this.configuration;
    }

    ZooKeeperConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setPath(String path) {
        this.getConfiguration().setPath(path);
    }

    @ManagedAttribute
    public String getPath() {
        return this.getConfiguration().getPath();
    }

    @ManagedAttribute
    public int getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    public void setTimeout(int timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    @ManagedAttribute
    public boolean getRepeat() {
        return this.getConfiguration().isRepeat();
    }

    public void setRepeat(boolean shouldRepeat) {
        this.getConfiguration().setRepeat(shouldRepeat);
    }

    @ManagedAttribute
    public List<String> getServers() {
        return this.getConfiguration().getServers();
    }

    public void setServers(List<String> servers) {
        this.getConfiguration().setServers(servers);
    }

    @ManagedAttribute
    public boolean isListChildren() {
        return this.getConfiguration().isListChildren();
    }

    public void setListChildren(boolean listChildren) {
        this.getConfiguration().setListChildren(listChildren);
    }

    @ManagedAttribute
    public boolean getCreate() {
        return this.getConfiguration().isCreate();
    }

    public void setCreate(boolean shouldCreate) {
        this.getConfiguration().setCreate(shouldCreate);
    }

    @ManagedAttribute
    public long getBackoff() {
        return this.getConfiguration().getBackoff();
    }

    public void setBackoff(long backoff) {
        this.getConfiguration().setBackoff(backoff);
    }

    @ManagedOperation
    public void addServer(String server) {
        this.getConfiguration().addZookeeperServer(server);
    }

    @ManagedOperation
    public void clearServers() {
        this.getConfiguration().getServers().clear();
    }

    @ManagedAttribute
    public boolean isSendEmptyMessageOnDelete() {
        return this.getConfiguration().isSendEmptyMessageOnDelete();
    }

    public void setSendEmptyMessageOnDelete(boolean sendEmptyMessageOnDelete) {
        this.getConfiguration().setSendEmptyMessageOnDelete(sendEmptyMessageOnDelete);
    }

    protected void doStop() throws Exception {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }
}

