/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConsumerHandler;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanProducer;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.embedded.InfinispanConsumerEmbeddedHandler;
import org.apache.camel.component.infinispan.remote.InfinispanConsumerRemoteHandler;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteOperation;
import org.apache.camel.support.DefaultConsumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(InfinispanProducer.class);
    private final InfinispanConfiguration configuration;
    private final InfinispanManager manager;
    private final String cacheName;
    private InfinispanEventListener listener;
    private InfinispanConsumerHandler consumerHandler;
    private BasicCache<Object, Object> cache;
    private ContinuousQuery<Object, Object> continuousQuery;

    public InfinispanConsumer(InfinispanEndpoint endpoint, Processor processor, String cacheName, InfinispanManager manager, InfinispanConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = manager;
    }

    public void processEvent(String eventType, boolean isPre, String cacheName, Object key) {
        this.processEvent(eventType, isPre, cacheName, key, null);
    }

    public void processEvent(String eventType, boolean isPre, String cacheName, Object key, Object eventData) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getMessage().setHeader("CamelInfinispanEventType", (Object)eventType);
        exchange.getMessage().setHeader("CamelInfinispanIsPre", (Object)isPre);
        exchange.getMessage().setHeader("CamelInfinispanCacheName", (Object)cacheName);
        exchange.getMessage().setHeader("CamelInfinispanKey", key);
        if (eventData != null) {
            exchange.getMessage().setHeader("CamelInfinispanEventData", eventData);
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error("Error processing event ", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doStart() throws Exception {
        super.doStart();
        this.manager.start();
        this.cache = this.manager.getCache(this.cacheName);
        if (this.configuration.hasQueryBuilder()) {
            if (!InfinispanUtil.isRemote(this.cache)) throw new IllegalArgumentException("Can't run continuous queries against embedded cache (" + this.cache.getName() + ")");
            RemoteCache<Object, Object> remoteCache = InfinispanUtil.asRemote(this.cache);
            Query query = InfinispanRemoteOperation.buildQuery(this.configuration.getQueryBuilder(), remoteCache);
            this.continuousQuery = Search.getContinuousQuery(remoteCache);
            this.continuousQuery.addContinuousQueryListener(query, (ContinuousQueryListener)new ContinuousQueryEventListener(this.cache.getName()));
            return;
        } else {
            if (this.manager.isCacheContainerEmbedded()) {
                this.consumerHandler = InfinispanConsumerEmbeddedHandler.INSTANCE;
            } else {
                if (!this.manager.isCacheContainerRemote()) throw new UnsupportedOperationException("Unsupported CacheContainer type " + this.manager.getCacheContainer().getClass().getName());
                this.consumerHandler = InfinispanConsumerRemoteHandler.INSTANCE;
            }
            this.listener = this.consumerHandler.start(this);
        }
    }

    protected void doStop() throws Exception {
        if (this.continuousQuery != null) {
            this.continuousQuery.removeAllListeners();
        }
        if (this.consumerHandler != null) {
            this.consumerHandler.stop(this);
        }
        this.manager.stop();
        super.doStop();
    }

    public BasicCache<Object, Object> getCache() {
        return this.cache;
    }

    public InfinispanEventListener getListener() {
        return this.listener;
    }

    public InfinispanConfiguration getConfiguration() {
        return this.configuration;
    }

    private class ContinuousQueryEventListener
    implements ContinuousQueryListener<Object, Object> {
        private final String cacheName;

        ContinuousQueryEventListener(String cacheName) {
            this.cacheName = cacheName;
        }

        public void resultJoining(Object key, Object value) {
            InfinispanConsumer.this.processEvent("CacheEntryJoining", false, this.cacheName, key, value);
        }

        public void resultUpdated(Object key, Object value) {
            InfinispanConsumer.this.processEvent("CacheEntryUpdated", false, this.cacheName, key, value);
        }

        public void resultLeaving(Object key) {
            InfinispanConsumer.this.processEvent("CacheEntryLeaving", false, this.cacheName, key);
        }
    }
}

