/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elytron;

import io.undertow.server.HttpServerExchange;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.elytron.ElytronComponent;
import org.apache.camel.component.elytron.ElytronConsumer;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.wildfly.security.auth.server.SecurityIdentity;

@UriEndpoint(firstVersion="3.1.0", scheme="elytron", title="Elytron", syntax="elytron:httpURI", label="http", lenientProperties=true, extendsScheme="undertow")
public class ElytronEndpoint
extends UndertowEndpoint {
    public static final String SECURITY_IDENTITY_HEADER = "securityIdentity";
    @UriParam(label="common")
    private String allowedRoles = "";
    private List<String> allowedRolesList = Collections.emptyList();

    public ElytronEndpoint(String uri, UndertowComponent component) {
        super(uri, component);
    }

    public ElytronComponent getElytronComponent() {
        return (ElytronComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ElytronConsumer(this, processor);
    }

    public Exchange createExchange(HttpServerExchange httpExchange) throws Exception {
        Exchange exchange = super.createExchange(httpExchange);
        SecurityIdentity securityIdentity = this.getElytronComponent().getSecurityDomain().getCurrentSecurityIdentity();
        exchange.getIn().setHeader(SECURITY_IDENTITY_HEADER, (Object)securityIdentity);
        return exchange;
    }

    public List<String> getAllowedRolesList() {
        return this.allowedRolesList;
    }

    public String getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(String allowedRoles) {
        this.allowedRolesList = allowedRoles == null ? null : Arrays.asList(allowedRoles.split("\\s*,\\s*"));
    }
}

