/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elytron;

import io.undertow.server.HttpServerExchange;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.Processor;
import org.apache.camel.component.elytron.ElytronEndpoint;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;

public class ElytronConsumer
extends UndertowConsumer {
    public ElytronConsumer(UndertowEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public ElytronEndpoint getElytronEndpoint() {
        return (ElytronEndpoint)super.getEndpoint();
    }

    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        SecurityIdentity identity = this.getElytronEndpoint().getElytronComponent().getSecurityDomain().getCurrentSecurityIdentity();
        if (identity != null) {
            HashSet<String> roles = new HashSet<String>();
            Roles identityRoles = identity.getRoles();
            if (identityRoles != null) {
                for (String roleName : identityRoles) {
                    roles.add(roleName);
                }
            }
            if (this.isAllowed(roles, this.getElytronEndpoint().getAllowedRolesList())) {
                super.handleRequest(httpExchange);
            } else {
                httpExchange.setStatusCode(403);
                httpExchange.endExchange();
            }
            return;
        }
        super.handleRequest(httpExchange);
    }

    public boolean isAllowed(Set<String> roles, List<String> allowedRoles) {
        for (String role : allowedRoles) {
            if (!roles.contains(role)) continue;
            return true;
        }
        return false;
    }
}

