/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elytron;

import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Provider;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.component.elytron.ElytronEndpoint;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronRunAsHandler;
import org.wildfly.security.WildFlyElytronBaseProvider;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.http.HttpAuthenticationFactory;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.bearer.WildFlyElytronHttpBearerProvider;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="elytron")
public class ElytronComponent
extends UndertowComponent {
    @Metadata(label="advanced", required=true)
    private SecurityDomain.Builder securityDomainBuilder;
    @Metadata(label="advanced", defaultValue="BEARER_TOKEN")
    private String mechanismName = "BEARER_TOKEN";
    @Metadata(label="advanced", defaultValue="instance of WildFlyElytronHttpBearerProvider")
    private WildFlyElytronBaseProvider elytronProvider = WildFlyElytronHttpBearerProvider.getInstance();
    private SecurityDomain securityDomain;

    public ElytronComponent() {
    }

    public ElytronComponent(CamelContext context) {
        super(context);
    }

    protected String getComponentName() {
        return "elytron";
    }

    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new ElytronEndpoint(endpointUri.toString(), component);
    }

    public HttpHandler registerEndpoint(HttpHandlerRegistrationInfo registrationInfo, SSLContext sslContext, HttpHandler handler) {
        return super.registerEndpoint(registrationInfo, sslContext, this.wrap(handler, this.getSecurityDomain()));
    }

    public SecurityDomain.Builder getSecurityDomainBuilder() {
        return this.securityDomainBuilder;
    }

    public void setSecurityDomainBuilder(SecurityDomain.Builder securityDomainBuilder) {
        this.securityDomainBuilder = securityDomainBuilder;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public void setMechanismName(String mechanismName) {
        this.mechanismName = mechanismName;
    }

    public WildFlyElytronBaseProvider getElytronProvider() {
        return this.elytronProvider;
    }

    public void setElytronProvider(WildFlyElytronBaseProvider elytronProvider) {
        this.elytronProvider = elytronProvider;
    }

    SecurityDomain getSecurityDomain() {
        if (this.securityDomain == null) {
            this.securityDomain = this.securityDomainBuilder.build();
        }
        return this.securityDomain;
    }

    private HttpHandler wrap(HttpHandler toWrap, SecurityDomain securityDomain) {
        HttpAuthenticationFactory httpAuthenticationFactory = this.createHttpAuthenticationFactory(securityDomain);
        ElytronRunAsHandler rootHandler = new ElytronRunAsHandler(toWrap);
        rootHandler = new AuthenticationCallHandler((HttpHandler)rootHandler);
        rootHandler = new AuthenticationConstraintHandler((HttpHandler)rootHandler);
        return ElytronContextAssociationHandler.builder().setNext((HttpHandler)rootHandler).setMechanismSupplier(() -> {
            try {
                return Collections.singletonList(httpAuthenticationFactory.createMechanism(this.mechanismName));
            }
            catch (HttpAuthenticationException e) {
                throw new RuntimeException(e);
            }
        }).build();
    }

    private HttpAuthenticationFactory createHttpAuthenticationFactory(SecurityDomain securityDomain) {
        SecurityProviderServerMechanismFactory providerFactory = new SecurityProviderServerMechanismFactory(() -> new Provider[]{this.getElytronProvider()});
        FilterServerMechanismFactory httpServerMechanismFactory = new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)providerFactory, true, new String[]{this.mechanismName});
        return HttpAuthenticationFactory.builder().setSecurityDomain(securityDomain).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)MechanismConfiguration.builder().addMechanismRealm(MechanismRealmConfiguration.builder().setRealmName("Elytron Realm").build()).build())).setFactory((HttpServerAuthenticationMechanismFactory)httpServerMechanismFactory).build();
    }
}

