/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.yammer.ApiRequestor;
import org.apache.camel.component.yammer.YammerConfiguration;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.YammerFunctionType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="yammer")
public class YammerComponent
extends DefaultComponent {
    @Metadata(label="security", secret=true)
    private String consumerKey;
    @Metadata(label="security", secret=true)
    private String consumerSecret;
    @Metadata(label="security", secret=true)
    private String accessToken;
    @Metadata(label="advanced")
    private YammerConfiguration config;
    @Metadata(label="advanced")
    private ApiRequestor requestor;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        YammerConfiguration endpointConfig = this.getConfig();
        if (endpointConfig == null) {
            endpointConfig = new YammerConfiguration();
        }
        endpointConfig.setConsumerKey(this.consumerKey);
        endpointConfig.setConsumerSecret(this.consumerSecret);
        endpointConfig.setAccessToken(this.accessToken);
        endpointConfig.setFunction(YammerFunctionType.fromUri(remaining));
        endpointConfig.setRequestor(this.requestor);
        YammerEndpoint endpoint = new YammerEndpoint(uri, this, endpointConfig);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public YammerConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(YammerConfiguration config) {
        this.config = config;
    }

    public ApiRequestor getRequestor() {
        return this.requestor;
    }

    public void setRequestor(ApiRequestor requestor) {
        this.requestor = requestor;
    }
}

