/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.component.google.pubsub.consumer.PubsubAcknowledgement;
import org.apache.camel.spi.Synchronization;

public class ExchangeAckTransaction
extends PubsubAcknowledgement
implements Synchronization {
    public ExchangeAckTransaction(GooglePubsubEndpoint endpoint) {
        super(endpoint);
    }

    public void onComplete(Exchange exchange) {
        this.acknowledge(this.getAckIdList(exchange));
    }

    public void onFailure(Exchange exchange) {
        Integer deadline = 0;
        Object configuredDeadline = exchange.getIn().getHeader("CamelGooglePubsub.AckDeadline");
        if (configuredDeadline != null && Integer.class.isInstance(configuredDeadline)) {
            deadline = (Integer)configuredDeadline;
        }
        if (configuredDeadline != null && String.class.isInstance(configuredDeadline)) {
            try {
                deadline = Integer.valueOf((String)configuredDeadline);
            }
            catch (Exception e) {
                this.log.warn("Unable to parse ACK Deadline header value", (Throwable)e);
            }
        }
        if (deadline != 0) {
            this.log.trace(" Exchange {} : Ack deadline : {}", (Object)exchange.getExchangeId(), (Object)deadline);
        }
        this.resetAckDeadline(this.getAckIdList(exchange), deadline);
    }

    private List<String> getAckIdList(Exchange exchange) {
        ArrayList<String> ackList = new ArrayList<String>();
        if (null != exchange.getProperty("CamelGroupedExchange")) {
            for (Exchange ex : (List)exchange.getProperty("CamelGroupedExchange")) {
                String ackId = (String)ex.getIn().getHeader("CamelGooglePubsub.MsgAckId");
                if (null == ackId) continue;
                ackList.add(ackId);
            }
        } else {
            ackList.add((String)exchange.getIn().getHeader("CamelGooglePubsub.MsgAckId"));
        }
        return ackList;
    }
}

