/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.parser.ParserResult;
import org.apache.camel.parser.helper.CamelJavaParserHelper;
import org.apache.camel.parser.helper.CamelJavaTreeParserHelper;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CamelRouteDetails;
import org.apache.camel.parser.model.CamelSimpleExpressionDetails;
import org.apache.camel.tooling.util.Strings;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class RouteBuilderParser {
    private RouteBuilderParser() {
    }

    public static List<CamelNodeDetails> parseRouteBuilderTree(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, boolean includeInlinedRouteBuilders) {
        List<MethodSource<JavaClassSource>> inlinedMethods;
        ArrayList<MethodSource<JavaClassSource>> methods = new ArrayList<MethodSource<JavaClassSource>>();
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            methods.add(method);
        }
        if (includeInlinedRouteBuilders && !(inlinedMethods = CamelJavaParserHelper.findInlinedConfigureMethods(clazz)).isEmpty()) {
            methods.addAll(inlinedMethods);
        }
        CamelJavaTreeParserHelper parser = new CamelJavaTreeParserHelper();
        ArrayList<CamelNodeDetails> list = new ArrayList<CamelNodeDetails>();
        for (MethodSource methodSource : methods) {
            List<CamelNodeDetails> details = parser.parseCamelRouteTree(clazz, baseDir, fullyQualifiedFileName, (MethodSource<JavaClassSource>)methodSource);
            list.addAll(details);
        }
        Collections.reverse(list);
        return list;
    }

    public static void parseRouteBuilderEndpoints(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints) {
        RouteBuilderParser.parseRouteBuilderEndpoints(clazz, baseDir, fullyQualifiedFileName, endpoints, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void parseRouteBuilderEndpoints(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints, List<String> unparsable, boolean includeInlinedRouteBuilders) {
        List<MethodSource<JavaClassSource>> inlinedMethods;
        for (FieldSource field : clazz.getFields()) {
            void var9_9;
            Object internal;
            String uri = null;
            Object var9_10 = null;
            for (Annotation ann : field.getAnnotations()) {
                void var9_14;
                boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                if (!valid) continue;
                Expression expression = (Expression)ann.getInternal();
                if (expression instanceof SingleMemberAnnotation) {
                    Expression expression2 = ((SingleMemberAnnotation)expression).getValue();
                } else if (expression instanceof NormalAnnotation) {
                    List values = ((NormalAnnotation)expression).values();
                    for (Object value : values) {
                        MemberValuePair pair = (MemberValuePair)value;
                        if (!"uri".equals(pair.getName().toString())) continue;
                        Expression expression3 = pair.getValue();
                        break;
                    }
                }
                uri = CamelJavaParserHelper.getLiteralValue(clazz, null, (Expression)var9_14);
            }
            if (Strings.isNullOrEmpty(uri) || RouteBuilderParser.findEndpointByUri(endpoints, uri) != null) continue;
            String fileName = fullyQualifiedFileName;
            if (fileName.startsWith(baseDir)) {
                fileName = fileName.substring(baseDir.length() + 1);
            }
            String id = field.getName();
            CamelEndpointDetails detail = new CamelEndpointDetails();
            detail.setFileName(fileName);
            detail.setClassName(clazz.getQualifiedName());
            detail.setEndpointInstance(id);
            detail.setEndpointUri(uri);
            detail.setEndpointComponentName(RouteBuilderParser.endpointComponentName(uri));
            Object object = internal = var9_9 != null ? var9_9 : field.getInternal();
            if (internal instanceof ASTNode) {
                int endLine;
                int pos = ((ASTNode)internal).getStartPosition();
                int len = ((ASTNode)internal).getLength();
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), pos);
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), pos + len)) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setAbsolutePosition(pos);
                int linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), pos);
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
            }
            endpoints.add(detail);
        }
        ArrayList<MethodSource<JavaClassSource>> methods = new ArrayList<MethodSource<JavaClassSource>>();
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            methods.add(method);
        }
        if (includeInlinedRouteBuilders && !(inlinedMethods = CamelJavaParserHelper.findInlinedConfigureMethods(clazz)).isEmpty()) {
            methods.addAll(inlinedMethods);
        }
        for (MethodSource methodSource : methods) {
            int linePos;
            int line;
            CamelEndpointDetails detail;
            String fileName;
            List<ParserResult> uris = CamelJavaParserHelper.parseCamelConsumerUris((MethodSource<JavaClassSource>)methodSource, true, true);
            for (ParserResult result : uris) {
                int lineEnd;
                if (!result.isParsed()) {
                    if (unparsable == null) continue;
                    unparsable.add(result.getElement());
                    continue;
                }
                fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                detail = new CamelEndpointDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName(methodSource.getName());
                detail.setEndpointInstance(null);
                detail.setEndpointUri(result.getElement());
                line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((lineEnd = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + lineEnd);
                }
                detail.setAbsolutePosition(result.getPosition());
                linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), result.getPosition());
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
                detail.setEndpointComponentName(RouteBuilderParser.endpointComponentName(result.getElement()));
                detail.setConsumerOnly(true);
                detail.setProducerOnly(false);
                endpoints.add(detail);
            }
            uris = CamelJavaParserHelper.parseCamelProducerUris((MethodSource<JavaClassSource>)methodSource, true, true);
            for (ParserResult result : uris) {
                int endLine;
                if (!result.isParsed()) {
                    if (unparsable == null) continue;
                    unparsable.add(result.getElement());
                    continue;
                }
                fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                detail = new CamelEndpointDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName(methodSource.getName());
                detail.setEndpointInstance(null);
                detail.setEndpointUri(result.getElement());
                line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setAbsolutePosition(result.getPosition());
                linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), result.getPosition());
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
                detail.setEndpointComponentName(RouteBuilderParser.endpointComponentName(result.getElement()));
                detail.setConsumerOnly(false);
                detail.setProducerOnly(true);
                endpoints.add(detail);
            }
        }
    }

    public static void parseRouteBuilderSimpleExpressions(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelSimpleExpressionDetails> simpleExpressions) {
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            List<ParserResult> expressions = CamelJavaParserHelper.parseCamelSimpleExpressions(method);
            for (ParserResult result : expressions) {
                int endLine;
                if (!result.isParsed()) continue;
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelSimpleExpressionDetails detail = new CamelSimpleExpressionDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setAbsolutePosition(result.getPosition());
                int linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), result.getPosition());
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
                detail.setSimple(result.getElement());
                boolean predicate = result.getPredicate() != null ? result.getPredicate() : false;
                boolean expression = !predicate;
                detail.setPredicate(predicate);
                detail.setExpression(expression);
                simpleExpressions.add(detail);
            }
        }
    }

    public static void parseRouteBuilderRouteIds(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelRouteDetails> routes) {
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            List<ParserResult> expressions = CamelJavaParserHelper.parseCamelRouteIds(method);
            for (ParserResult result : expressions) {
                int endLine;
                if (!result.isParsed()) continue;
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelRouteDetails detail = new CamelRouteDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setRouteId(result.getElement());
                routes.add(detail);
            }
        }
    }

    private static CamelEndpointDetails findEndpointByUri(List<CamelEndpointDetails> endpoints, String uri) {
        for (CamelEndpointDetails detail : endpoints) {
            if (!uri.equals(detail.getEndpointUri())) continue;
            return detail;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLineNumber(String content, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new StringReader(content));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int n = lines;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLinePosition(String content, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new StringReader(content));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int prev = current - (line.length() + 1);
                int rel = position - prev;
                int n = rel + 1;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(":")) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }
}

