/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.DynamicRouter;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutingSlip;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public final class DefaultAnnotationBasedProcessorFactory
implements AnnotationBasedProcessorFactory {
    public AsyncProcessor createDynamicRouter(CamelContext camelContext, DynamicRouter annotation) {
        org.apache.camel.processor.DynamicRouter dynamicRouter = new org.apache.camel.processor.DynamicRouter(camelContext);
        dynamicRouter.setDelimiter(annotation.delimiter());
        dynamicRouter.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
        dynamicRouter.setCacheSize(annotation.cacheSize());
        return dynamicRouter;
    }

    public AsyncProcessor createRecipientList(CamelContext camelContext, RecipientList annotation) {
        ExecutorService executor;
        org.apache.camel.processor.RecipientList recipientList = new org.apache.camel.processor.RecipientList(camelContext, annotation.delimiter());
        recipientList.setStopOnException(annotation.stopOnException());
        recipientList.setStopOnAggregateException(annotation.stopOnAggregateException());
        recipientList.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
        recipientList.setParallelProcessing(annotation.parallelProcessing());
        recipientList.setParallelAggregate(annotation.parallelAggregate());
        recipientList.setStreaming(annotation.streaming());
        recipientList.setTimeout(annotation.timeout());
        recipientList.setCacheSize(annotation.cacheSize());
        recipientList.setShareUnitOfWork(annotation.shareUnitOfWork());
        if (ObjectHelper.isNotEmpty((Object)annotation.executorServiceRef())) {
            executor = camelContext.getExecutorServiceManager().newDefaultThreadPool((Object)this, annotation.executorServiceRef());
            recipientList.setExecutorService(executor);
        }
        if (annotation.parallelProcessing() && recipientList.getExecutorService() == null) {
            executor = camelContext.getExecutorServiceManager().newDefaultThreadPool((Object)this, "@RecipientList");
            recipientList.setExecutorService(executor);
        }
        if (ObjectHelper.isNotEmpty((Object)annotation.strategyRef())) {
            AggregationStrategy strategy = (AggregationStrategy)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)annotation.strategyRef(), AggregationStrategy.class);
            recipientList.setAggregationStrategy(strategy);
        }
        if (ObjectHelper.isNotEmpty((Object)annotation.onPrepareRef())) {
            Processor onPrepare = (Processor)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)annotation.onPrepareRef(), Processor.class);
            recipientList.setOnPrepare(onPrepare);
        }
        return recipientList;
    }

    public AsyncProcessor createRoutingSlip(CamelContext camelContext, RoutingSlip annotation) {
        org.apache.camel.processor.RoutingSlip routingSlip = new org.apache.camel.processor.RoutingSlip(camelContext);
        routingSlip.setDelimiter(annotation.delimiter());
        routingSlip.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
        routingSlip.setCacheSize(annotation.cacheSize());
        return routingSlip;
    }
}

