/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.mq.MQ2ComponentVerifierExtension;
import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.MQ2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.mq.MqClient;

@org.apache.camel.spi.annotations.Component(value="aws2-mq")
public class MQ2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private MQ2Configuration configuration;

    public MQ2Component() {
        this(null);
    }

    public MQ2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MQ2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MQ2Configuration configuration = this.configuration != null ? this.configuration.copy() : new MQ2Configuration();
        MQ2Endpoint endpoint = new MQ2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getAmazonMqClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonMQClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MQ2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MQ2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(MQ2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(MqClient.class);
        if (clients.size() == 1) {
            configuration.setAmazonMqClient((MqClient)clients.stream().findFirst().get());
        }
    }
}

