/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.dataformat.ASN1DataFormat;
import org.apache.camel.model.dataformat.Any23DataFormat;
import org.apache.camel.model.dataformat.AvroDataFormat;
import org.apache.camel.model.dataformat.BarcodeDataFormat;
import org.apache.camel.model.dataformat.Base64DataFormat;
import org.apache.camel.model.dataformat.BeanioDataFormat;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.CBORDataFormat;
import org.apache.camel.model.dataformat.CryptoDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.dataformat.FhirDataformat;
import org.apache.camel.model.dataformat.FhirJsonDataFormat;
import org.apache.camel.model.dataformat.FhirXmlDataFormat;
import org.apache.camel.model.dataformat.FlatpackDataFormat;
import org.apache.camel.model.dataformat.GrokDataFormat;
import org.apache.camel.model.dataformat.GzipDataFormat;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.IcalDataFormat;
import org.apache.camel.model.dataformat.JacksonXMLDataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.JsonApiDataFormat;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.LZFDataFormat;
import org.apache.camel.model.dataformat.MimeMultipartDataFormat;
import org.apache.camel.model.dataformat.PGPDataFormat;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.RssDataFormat;
import org.apache.camel.model.dataformat.SoapJaxbDataFormat;
import org.apache.camel.model.dataformat.SyslogDataFormat;
import org.apache.camel.model.dataformat.TarFileDataFormat;
import org.apache.camel.model.dataformat.ThriftDataFormat;
import org.apache.camel.model.dataformat.TidyMarkupDataFormat;
import org.apache.camel.model.dataformat.UniVocityCsvDataFormat;
import org.apache.camel.model.dataformat.UniVocityFixedWidthDataFormat;
import org.apache.camel.model.dataformat.UniVocityTsvDataFormat;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.model.dataformat.XStreamDataFormat;
import org.apache.camel.model.dataformat.XmlRpcDataFormat;
import org.apache.camel.model.dataformat.YAMLDataFormat;
import org.apache.camel.model.dataformat.ZipDeflaterDataFormat;
import org.apache.camel.model.dataformat.ZipFileDataFormat;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.dataformat.ASN1DataFormatReifier;
import org.apache.camel.reifier.dataformat.Any23DataFormatReifier;
import org.apache.camel.reifier.dataformat.AvroDataFormatReifier;
import org.apache.camel.reifier.dataformat.BarcodeDataFormatReifier;
import org.apache.camel.reifier.dataformat.Base64DataFormatReifier;
import org.apache.camel.reifier.dataformat.BeanioDataFormatReifier;
import org.apache.camel.reifier.dataformat.BindyDataFormatReifier;
import org.apache.camel.reifier.dataformat.CBORDataFormatReifier;
import org.apache.camel.reifier.dataformat.CryptoDataFormatReifier;
import org.apache.camel.reifier.dataformat.CsvDataFormatReifier;
import org.apache.camel.reifier.dataformat.CustomDataFormatReifier;
import org.apache.camel.reifier.dataformat.FhirDataFormatReifier;
import org.apache.camel.reifier.dataformat.FhirJsonDataFormatReifier;
import org.apache.camel.reifier.dataformat.FhirXmlDataFormatReifier;
import org.apache.camel.reifier.dataformat.FlatpackDataFormatReifier;
import org.apache.camel.reifier.dataformat.GrokDataFormatReifier;
import org.apache.camel.reifier.dataformat.GzipDataFormatReifier;
import org.apache.camel.reifier.dataformat.HL7DataFormatReifier;
import org.apache.camel.reifier.dataformat.IcalDataFormatReifier;
import org.apache.camel.reifier.dataformat.JacksonXMLDataFormatReifier;
import org.apache.camel.reifier.dataformat.JaxbDataFormatReifier;
import org.apache.camel.reifier.dataformat.JsonApiDataFormatReifier;
import org.apache.camel.reifier.dataformat.JsonDataFormatReifier;
import org.apache.camel.reifier.dataformat.LZFDataFormatReifier;
import org.apache.camel.reifier.dataformat.MimeMultipartDataFormatReifier;
import org.apache.camel.reifier.dataformat.PGPDataFormatReifier;
import org.apache.camel.reifier.dataformat.ProtobufDataFormatReifier;
import org.apache.camel.reifier.dataformat.RssDataFormatReifier;
import org.apache.camel.reifier.dataformat.SoapJaxbDataFormatReifier;
import org.apache.camel.reifier.dataformat.SyslogDataFormatReifier;
import org.apache.camel.reifier.dataformat.TarFileDataFormatReifier;
import org.apache.camel.reifier.dataformat.ThriftDataFormatReifier;
import org.apache.camel.reifier.dataformat.TidyMarkupDataFormatReifier;
import org.apache.camel.reifier.dataformat.UniVocityCsvDataFormatReifier;
import org.apache.camel.reifier.dataformat.UniVocityFixedWidthDataFormatReifier;
import org.apache.camel.reifier.dataformat.UniVocityTsvDataFormatReifier;
import org.apache.camel.reifier.dataformat.XMLSecurityDataFormatReifier;
import org.apache.camel.reifier.dataformat.XStreamDataFormatReifier;
import org.apache.camel.reifier.dataformat.XmlRpcDataFormatReifier;
import org.apache.camel.reifier.dataformat.YAMLDataFormatReifier;
import org.apache.camel.reifier.dataformat.ZipDataFormatReifier;
import org.apache.camel.reifier.dataformat.ZipFileDataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataFormatReifier<T extends DataFormatDefinition>
extends AbstractReifier {
    private static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/configurer/";
    private static final Logger LOG = LoggerFactory.getLogger(DataFormatReifier.class);
    private static final Map<Class<? extends DataFormatDefinition>, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>>> DATAFORMATS;
    protected final T definition;

    public DataFormatReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<? extends DataFormatDefinition> dataFormatClass, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>> creator) {
        DATAFORMATS.put(dataFormatClass, creator);
    }

    public static void clearReifiers() {
        DATAFORMATS.clear();
    }

    public static DataFormat getDataFormat(CamelContext camelContext, DataFormatDefinition type, String ref) {
        if (type == null) {
            org.apache.camel.util.ObjectHelper.notNull((Object)ref, (String)"ref or type");
            DataFormat dataFormat = (DataFormat)camelContext.getRegistry().lookupByNameAndType(ref, DataFormat.class);
            if (dataFormat != null) {
                return dataFormat;
            }
            type = ((Model)camelContext.getExtension(Model.class)).resolveDataFormatDefinition(ref);
            if (type == null) {
                dataFormat = camelContext.resolveDataFormat(ref);
                if (dataFormat == null) {
                    throw new IllegalArgumentException("Cannot find data format in registry with ref: " + ref);
                }
                return dataFormat;
            }
        }
        if (type.getDataFormat() != null) {
            return type.getDataFormat();
        }
        return DataFormatReifier.reifier(camelContext, type).createDataFormat();
    }

    public static DataFormatReifier<? extends DataFormatDefinition> reifier(CamelContext camelContext, DataFormatDefinition definition) {
        BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>> reifier = DATAFORMATS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(camelContext, definition);
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public DataFormat createDataFormat() {
        DataFormat dataFormat = ((DataFormatDefinition)this.definition).getDataFormat();
        if (dataFormat == null) {
            dataFormat = this.doCreateDataFormat();
            if (dataFormat != null) {
                if (dataFormat instanceof DataFormatContentTypeHeader) {
                    boolean contentTypeHeader = this.parseBoolean(((DataFormatDefinition)this.definition).getContentTypeHeader(), true);
                    ((DataFormatContentTypeHeader)dataFormat).setContentTypeHeader(contentTypeHeader);
                }
                this.configureDataFormat(dataFormat, this.camelContext);
            } else {
                throw new IllegalArgumentException("Data format '" + (((DataFormatDefinition)this.definition).getDataFormatName() != null ? ((DataFormatDefinition)this.definition).getDataFormatName() : "<null>") + "' could not be created. Ensure that the data format is valid and the associated Camel component is present on the classpath");
            }
        }
        return dataFormat;
    }

    protected DataFormat doCreateDataFormat() {
        String dfn = ((DataFormatDefinition)this.definition).getDataFormatName();
        if (dfn != null) {
            return this.camelContext.createDataFormat(dfn);
        }
        return null;
    }

    private String getDataFormatName() {
        return ((DataFormatDefinition)this.definition).getDataFormatName();
    }

    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.prepareDataFormatConfig(properties);
        properties.entrySet().removeIf(e -> e.getValue() == null);
        PropertyConfigurer configurer = this.findPropertyConfigurer(dataFormat, camelContext);
        PropertyBindingSupport.build().withCamelContext(camelContext).withTarget((Object)dataFormat).withReference(true).withMandatory(true).withConfigurer(configurer).withProperties(properties).bind();
    }

    private PropertyConfigurer findPropertyConfigurer(DataFormat dataFormat, CamelContext camelContext) {
        PropertyConfigurer configurer = null;
        String name = this.getDataFormatName();
        LOG.trace("Discovering optional dataformat property configurer class for dataformat: {}", (Object)name);
        if (dataFormat instanceof PropertyConfigurerAware) {
            configurer = ((PropertyConfigurerAware)dataFormat).getPropertyConfigurer((Object)dataFormat);
            if (LOG.isDebugEnabled() && configurer != null) {
                LOG.debug("Discovered dataformat property configurer using the PropertyConfigurerAware: {} -> {}", (Object)name, (Object)configurer);
            }
        }
        if (configurer == null) {
            String configurerName = name + "-dataformat-configurer";
            configurer = (PropertyConfigurer)camelContext.getRegistry().lookupByNameAndType(configurerName, PropertyConfigurer.class);
            if (LOG.isDebugEnabled() && configurer != null) {
                LOG.debug("Discovered dataformat property configurer using the Camel registry: {} -> {}", (Object)configurerName, (Object)configurer);
            }
        }
        if (configurer == null) {
            try {
                Class clazz = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH).findOptionalClass(name + "-dataformat-configurer", null).orElse(null);
                if (clazz != null) {
                    configurer = (PropertyConfigurer)ObjectHelper.newInstance((Class)clazz, PropertyConfigurer.class);
                    if (LOG.isDebugEnabled() && configurer != null) {
                        LOG.debug("Discovered dataformat property configurer using the FactoryFinder: {} -> {}", (Object)name, (Object)configurer);
                    }
                }
            }
            catch (NoFactoryAvailableException e) {
                throw new RuntimeCamelException("Unable to retrieve dataformat property configurer factory finder", (Throwable)e);
            }
        }
        return configurer;
    }

    protected abstract void prepareDataFormatConfig(Map<String, Object> var1);

    static {
        HashMap<Class<? extends DataFormatDefinition>, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>>> map = new HashMap<Class<? extends DataFormatDefinition>, BiFunction<CamelContext, DataFormatDefinition, DataFormatReifier<? extends DataFormatDefinition>>>();
        map.put(Any23DataFormat.class, Any23DataFormatReifier::new);
        map.put(ASN1DataFormat.class, ASN1DataFormatReifier::new);
        map.put(AvroDataFormat.class, AvroDataFormatReifier::new);
        map.put(BarcodeDataFormat.class, BarcodeDataFormatReifier::new);
        map.put(Base64DataFormat.class, Base64DataFormatReifier::new);
        map.put(BeanioDataFormat.class, BeanioDataFormatReifier::new);
        map.put(BindyDataFormat.class, BindyDataFormatReifier::new);
        map.put(CBORDataFormat.class, CBORDataFormatReifier::new);
        map.put(CryptoDataFormat.class, CryptoDataFormatReifier::new);
        map.put(CsvDataFormat.class, CsvDataFormatReifier::new);
        map.put(CustomDataFormat.class, CustomDataFormatReifier::new);
        map.put(FhirDataformat.class, FhirDataFormatReifier::new);
        map.put(FhirJsonDataFormat.class, FhirJsonDataFormatReifier::new);
        map.put(FhirXmlDataFormat.class, FhirXmlDataFormatReifier::new);
        map.put(FlatpackDataFormat.class, FlatpackDataFormatReifier::new);
        map.put(GrokDataFormat.class, GrokDataFormatReifier::new);
        map.put(GzipDataFormat.class, GzipDataFormatReifier::new);
        map.put(HL7DataFormat.class, HL7DataFormatReifier::new);
        map.put(IcalDataFormat.class, IcalDataFormatReifier::new);
        map.put(JacksonXMLDataFormat.class, JacksonXMLDataFormatReifier::new);
        map.put(JaxbDataFormat.class, JaxbDataFormatReifier::new);
        map.put(JsonApiDataFormat.class, JsonApiDataFormatReifier::new);
        map.put(JsonDataFormat.class, JsonDataFormatReifier::new);
        map.put(LZFDataFormat.class, LZFDataFormatReifier::new);
        map.put(MimeMultipartDataFormat.class, MimeMultipartDataFormatReifier::new);
        map.put(PGPDataFormat.class, PGPDataFormatReifier::new);
        map.put(ProtobufDataFormat.class, ProtobufDataFormatReifier::new);
        map.put(RssDataFormat.class, RssDataFormatReifier::new);
        map.put(SoapJaxbDataFormat.class, SoapJaxbDataFormatReifier::new);
        map.put(SyslogDataFormat.class, SyslogDataFormatReifier::new);
        map.put(TarFileDataFormat.class, TarFileDataFormatReifier::new);
        map.put(ThriftDataFormat.class, ThriftDataFormatReifier::new);
        map.put(TidyMarkupDataFormat.class, TidyMarkupDataFormatReifier::new);
        map.put(UniVocityCsvDataFormat.class, UniVocityCsvDataFormatReifier::new);
        map.put(UniVocityFixedWidthDataFormat.class, UniVocityFixedWidthDataFormatReifier::new);
        map.put(UniVocityTsvDataFormat.class, UniVocityTsvDataFormatReifier::new);
        map.put(XmlRpcDataFormat.class, XmlRpcDataFormatReifier::new);
        map.put(XMLSecurityDataFormat.class, XMLSecurityDataFormatReifier::new);
        map.put(XStreamDataFormat.class, XStreamDataFormatReifier::new);
        map.put(YAMLDataFormat.class, YAMLDataFormatReifier::new);
        map.put(ZipDeflaterDataFormat.class, ZipDataFormatReifier::new);
        map.put(ZipFileDataFormat.class, ZipFileDataFormatReifier::new);
        DATAFORMATS = map;
        ReifierStrategy.addReifierClearer(DataFormatReifier::clearReifiers);
    }
}

