/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eks;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.eks.EKS2ComponentVerifierExtension;
import org.apache.camel.component.aws2.eks.EKS2Configuration;
import org.apache.camel.component.aws2.eks.EKS2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.eks.EksClient;

@org.apache.camel.spi.annotations.Component(value="aws2-eks")
public class EKS2Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private EKS2Configuration configuration;

    public EKS2Component() {
        this(null);
    }

    public EKS2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new EKS2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EKS2Configuration configuration = this.configuration != null ? this.configuration.copy() : new EKS2Configuration();
        EKS2Endpoint endpoint = new EKS2Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getEksClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon eks client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public EKS2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EKS2Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(EKS2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(EksClient.class);
        if (clients.size() == 1) {
            configuration.setEksClient((EksClient)clients.stream().findFirst().get());
        }
    }
}

