/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.kms;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.aws2.kms.KMS2Operations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kms.KmsClient;

@UriParams
public class KMS2Configuration
implements Cloneable {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam(label="producer")
    private KmsClient kmsClient;
    @UriParam(label="producer", secret=true)
    private String accessKey;
    @UriParam(label="producer", secret=true)
    private String secretKey;
    @UriParam(label="producer")
    @Metadata(required=true)
    private KMS2Operations operation;
    @UriParam(enums="HTTP,HTTPS", defaultValue="HTTPS")
    private Protocol proxyProtocol = Protocol.HTTPS;
    @UriParam(label="producer")
    private String proxyHost;
    @UriParam(label="producer")
    private Integer proxyPort;
    @UriParam
    private String region;

    public KmsClient getKmsClient() {
        return this.kmsClient;
    }

    public void setKmsClient(KmsClient kmsClient) {
        this.kmsClient = kmsClient;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public KMS2Operations getOperation() {
        return this.operation;
    }

    public void setOperation(KMS2Operations operation) {
        this.operation = operation;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public KMS2Configuration copy() {
        try {
            return (KMS2Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

