/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.s3.S3ComponentVerifierExtension;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-s3")
public class S3Component
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private S3Configuration configuration;

    public S3Component() {
        this(null);
    }

    public S3Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new S3ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        if (remaining.startsWith("arn:")) {
            remaining = remaining.substring(remaining.lastIndexOf(":") + 1, remaining.length());
        }
        S3Configuration configuration = this.configuration != null ? this.configuration.copy() : new S3Configuration();
        configuration.setBucketName(remaining);
        S3Endpoint endpoint = new S3Endpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (!(configuration.isUseIAMCredentials().booleanValue() || configuration.getAmazonS3Client() != null || configuration.getAccessKey() != null && configuration.getSecretKey() != null)) {
            throw new IllegalArgumentException("useIAMCredentials is set to false, AmazonS3Client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public S3Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(S3Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(S3Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonS3.class);
        if (clients.size() == 1) {
            configuration.setAmazonS3Client((AmazonS3)clients.stream().findFirst().get());
        }
    }
}

