/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherConsumer
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 3600000L;
    private static final Logger LOG = LoggerFactory.getLogger(WeatherConsumer.class);
    private final String query;

    public WeatherConsumer(WeatherEndpoint endpoint, Processor processor, String query) {
        super((Endpoint)endpoint, processor);
        this.query = query;
    }

    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        LOG.debug("Going to execute the Weather query {}", (Object)this.query);
        HttpClient httpClient = ((WeatherComponent)this.getEndpoint().getComponent()).getHttpClient();
        GetMethod getMethod = new GetMethod(this.query);
        try {
            int status = httpClient.executeMethod((HttpMethod)getMethod);
            if (status != 200) {
                LOG.warn("HTTP call for weather returned error status code {} - {} as a result with query: {}", new Object[]{status, getMethod.getStatusLine(), this.query});
                int n = 0;
                return n;
            }
            String weather = (String)this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)getMethod.getResponseBodyAsStream());
            LOG.debug("Got back the Weather information {}", (Object)weather);
            if (ObjectHelper.isEmpty((Object)weather)) {
                int n = 0;
                return n;
            }
            Exchange exchange = this.getEndpoint().createExchange();
            String header = this.getEndpoint().getConfiguration().getHeaderName();
            if (header != null) {
                exchange.getIn().setHeader(header, (Object)weather);
            } else {
                exchange.getIn().setBody((Object)weather);
            }
            exchange.getIn().setHeader("CamelWeatherQuery", (Object)this.query);
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

