/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.weather.WeatherConfiguration;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.component.weather.http.AuthenticationHttpClientConfigurer;
import org.apache.camel.component.weather.http.AuthenticationMethod;
import org.apache.camel.component.weather.http.CompositeHttpConfigurer;
import org.apache.camel.component.weather.http.HttpClientConfigurer;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

@Component(value="weather")
public class WeatherComponent
extends DefaultComponent {
    private HttpClient httpClient;
    private String geolocationAccessKey;
    private String geolocationRequestHostIP;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        WeatherConfiguration configuration = new WeatherConfiguration(this);
        this.httpClient = this.createHttpClient(configuration);
        this.geolocationAccessKey = configuration.getGeolocationAccessKey();
        this.geolocationRequestHostIP = configuration.getGeolocationRequestHostIP();
        WeatherEndpoint endpoint = new WeatherEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    private HttpClient createHttpClient(WeatherConfiguration configuration) {
        HttpConnectionManager connectionManager = configuration.getHttpConnectionManager();
        if (connectionManager == null) {
            connectionManager = new MultiThreadedHttpConnectionManager();
        }
        HttpClient httpClient = new HttpClient(connectionManager);
        if (configuration.getProxyHost() != null && configuration.getProxyPort() != null) {
            httpClient.getHostConfiguration().setProxy(configuration.getProxyHost(), configuration.getProxyPort().intValue());
        }
        if (configuration.getProxyAuthUsername() != null && configuration.getProxyAuthMethod() == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        CompositeHttpConfigurer configurer = new CompositeHttpConfigurer();
        if (configuration.getProxyAuthMethod() != null) {
            this.configureProxyAuth(configurer, configuration.getProxyAuthMethod(), configuration.getProxyAuthUsername(), configuration.getProxyAuthPassword(), configuration.getProxyAuthDomain(), configuration.getProxyAuthHost());
        }
        configurer.configureHttpClient(httpClient);
        return httpClient;
    }

    private HttpClientConfigurer configureProxyAuth(CompositeHttpConfigurer configurer, String authMethod, String username, String password, String domain, String host) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        ObjectHelper.notNull((Object)authMethod, (String)"proxyAuthMethod");
        ObjectHelper.notNull((Object)username, (String)"proxyAuthUsername");
        ObjectHelper.notNull((Object)password, (String)"proxyAuthPassword");
        AuthenticationMethod auth = (AuthenticationMethod)((Object)this.getCamelContext().getTypeConverter().convertTo(AuthenticationMethod.class, (Object)authMethod));
        if (auth == AuthenticationMethod.Basic || auth == AuthenticationMethod.Digest) {
            configurer.addConfigurer(AuthenticationHttpClientConfigurer.basicAutenticationConfigurer(true, username, password));
            return configurer;
        }
        if (auth == AuthenticationMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"proxyAuthDomain");
            configurer.addConfigurer(AuthenticationHttpClientConfigurer.ntlmAutenticationConfigurer(true, username, password, domain, host));
            return configurer;
        }
        throw new IllegalArgumentException("Unknown proxyAuthMethod " + authMethod);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getGeolocationAccessKey() {
        return this.geolocationAccessKey;
    }

    public void setGeolocationAccessKey(String geolocationAccessKey) {
        this.geolocationAccessKey = geolocationAccessKey;
    }

    public String getGeolocationRequestHostIP() {
        return this.geolocationRequestHostIP;
    }

    public void setGeolocationRequestHostIP(String geolocationRequestHostIP) {
        this.geolocationRequestHostIP = geolocationRequestHostIP;
    }
}

