/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import com.ibm.icu.text.BreakIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicodeHelper
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(UnicodeHelper.class);
    private String input;
    private List<Integer> splitted;
    private Method method;

    public UnicodeHelper(String input, Method method) {
        this.input = input;
        this.method = method;
        this.splitted = null;
    }

    protected UnicodeHelper() {
    }

    public Method getMethod() {
        return this.method;
    }

    public String substring(int beginIndex) {
        this.split();
        int beginChar = this.splitted.get(beginIndex);
        return this.input.substring(beginChar);
    }

    public String substring(int beginIndex, int endIndex) {
        this.split();
        int beginChar = this.splitted.get(beginIndex);
        int endChar = this.splitted.get(endIndex);
        return this.input.substring(beginChar, endChar);
    }

    public int length() {
        this.split();
        return this.splitted.size() - 1;
    }

    public int indexOf(String str) {
        this.split();
        int tempIdx = this.input.indexOf(str);
        if (tempIdx < 0) {
            return tempIdx;
        }
        for (int b = 0; b < this.splitted.size() - 1; ++b) {
            if (tempIdx != this.splitted.get(b)) continue;
            for (int e = b + 1; e < this.splitted.size() - 1; ++e) {
                if (tempIdx + str.length() != this.splitted.get(e)) continue;
                return b;
            }
        }
        String cps = str.codePoints().mapToObj(cp -> String.format("0x%X", cp)).collect(Collectors.joining(","));
        throw new IllegalArgumentException("Given string (" + cps + ") is not a valid sequence of " + (Object)((Object)this.method) + "s.");
    }

    private void split() {
        if (this.splitted != null) {
            return;
        }
        if (this.method.equals((Object)Method.CODEPOINTS)) {
            this.splitCodepoints();
        } else {
            this.splitGrapheme();
        }
        LOG.debug("\"{}\" is splitted into {} ({} {}).", new Object[]{this.input, this.splitted, this.splitted.size() - 1, this.method});
        if (LOG.isTraceEnabled()) {
            for (int i = 0; i < this.splitted.size() - 2; ++i) {
                LOG.trace("segment [{},{}[=\"{}\".", new Object[]{this.splitted.get(i), this.splitted.get(i + 1), this.input.substring(this.splitted.get(i), this.splitted.get(i + 1))});
            }
        }
    }

    private void splitCodepoints() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int len = this.input.length();
        for (int i = 0; i < len; i += Character.codePointAt(this.input, i) > 65535 ? 2 : 1) {
            result.add(i);
        }
        result.add(len);
        this.splitted = result;
    }

    private void splitGrapheme() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        BreakIterator bit = BreakIterator.getCharacterInstance();
        bit.setText(this.input);
        result.add(bit.first());
        int end = bit.next();
        while (end != -1) {
            result.add(end);
            end = bit.next();
        }
        this.splitted = result;
    }

    public String toString() {
        return "StringHelper [input=" + this.input + ", splitted=" + this.splitted + ", method=" + (Object)((Object)this.method) + "]";
    }

    public static enum Method {
        CODEPOINTS,
        GRAPHEME;

    }
}

