/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.EventType;
import javax.cache.spi.CachingProvider;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheEntryEventFilters;
import org.apache.camel.component.jcache.JCacheProvider;
import org.apache.camel.component.jcache.JCacheProviders;
import org.apache.camel.util.ObjectHelper;

public class JCacheManager<K, V>
implements Closeable {
    private final JCacheConfiguration configuration;
    private final ClassLoader classLoader;
    private final String cacheName;
    private final CamelContext camelContext;
    private CachingProvider provider;
    private CacheManager manager;
    private Cache<K, V> cache;

    public JCacheManager(JCacheConfiguration configuration) {
        this.configuration = configuration;
        this.camelContext = configuration.getCamelContext();
        this.classLoader = this.camelContext != null ? this.camelContext.getApplicationContextClassLoader() : null;
        this.cacheName = configuration.getCacheName();
        this.provider = null;
        this.manager = null;
        this.cache = null;
    }

    public JCacheManager(Cache<K, V> cache) {
        this.configuration = null;
        this.camelContext = null;
        this.classLoader = null;
        this.cacheName = cache.getName();
        this.provider = null;
        this.manager = null;
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public JCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized Cache<K, V> getCache() throws Exception {
        if (this.cache == null) {
            JCacheProvider provider = JCacheProviders.lookup(this.configuration.getCachingProvider());
            this.cache = this.doGetCache(provider);
        }
        return this.cache;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.configuration != null) {
            if (this.cache != null) {
                this.cache.close();
            }
            if (this.manager != null) {
                this.manager.close();
            }
            if (this.provider != null) {
                this.provider.close();
            }
        }
    }

    protected CacheEntryEventFilter getEventFilter() {
        if (this.configuration.getEventFilters() != null) {
            return new JCacheEntryEventFilters.Chained(this.configuration.getEventFilters());
        }
        if (this.configuration.getFilteredEvents() != null) {
            ArrayList<EventType> list = new ArrayList<EventType>();
            for (String s : this.configuration.getFilteredEvents().split(",")) {
                EventType et = EventType.valueOf((String)s);
                list.add(et);
            }
            return new JCacheEntryEventFilters.Named(list);
        }
        return cacheEntryEvent -> true;
    }

    protected Cache<K, V> doGetCache(JCacheProvider jcacheProvider) throws Exception {
        if (this.cache == null) {
            String uri = this.configuration.getConfigurationUri();
            if (uri != null && this.camelContext != null) {
                uri = this.camelContext.resolvePropertyPlaceholders(uri);
            }
            this.provider = ObjectHelper.isNotEmpty((Object)jcacheProvider.className()) ? Caching.getCachingProvider((String)jcacheProvider.className()) : Caching.getCachingProvider();
            this.manager = this.provider.getCacheManager(ObjectHelper.isNotEmpty((Object)uri) ? URI.create(uri) : null, null, this.configuration.getCacheConfigurationProperties());
            this.cache = this.manager.getCache(this.cacheName);
            if (this.cache == null) {
                if (!this.configuration.isCreateCacheIfNotExists()) {
                    throw new IllegalStateException("Cache " + this.cacheName + " does not exist and should not be created (createCacheIfNotExists=false)");
                }
                this.cache = this.manager.createCache(this.cacheName, this.getOrCreateCacheConfiguration());
            }
        }
        return this.cache;
    }

    private Configuration getOrCreateCacheConfiguration() {
        if (this.configuration.getCacheConfiguration() != null) {
            return this.configuration.getCacheConfiguration();
        }
        MutableConfiguration mutableConfiguration = new MutableConfiguration();
        if (this.configuration.getCacheLoaderFactory() != null) {
            mutableConfiguration.setCacheLoaderFactory(this.configuration.getCacheLoaderFactory());
        }
        if (this.configuration.getCacheWriterFactory() != null) {
            mutableConfiguration.setCacheWriterFactory(this.configuration.getCacheWriterFactory());
        }
        if (this.configuration.getExpiryPolicyFactory() != null) {
            mutableConfiguration.setExpiryPolicyFactory(this.configuration.getExpiryPolicyFactory());
        }
        mutableConfiguration.setManagementEnabled(this.configuration.isManagementEnabled());
        mutableConfiguration.setStatisticsEnabled(this.configuration.isStatisticsEnabled());
        mutableConfiguration.setReadThrough(this.configuration.isReadThrough());
        mutableConfiguration.setStoreByValue(this.configuration.isStoreByValue());
        mutableConfiguration.setWriteThrough(this.configuration.isWriteThrough());
        return mutableConfiguration;
    }
}

