/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.milo.server.MiloServerConsumer;
import org.apache.camel.component.milo.server.MiloServerProducer;
import org.apache.camel.component.milo.server.internal.CamelNamespace;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="milo-server", syntax="milo-server:itemId", title="OPC UA Server", label="iot")
public class MiloServerEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private String itemId;
    private final CamelNamespace namespace;
    private CamelServerItem item;

    public MiloServerEndpoint(String uri, String itemId, CamelNamespace namespace, Component component) {
        super(uri, component);
        this.itemId = itemId;
        this.namespace = namespace;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.item = this.namespace.getOrAddItem(this.itemId);
    }

    protected void doStop() throws Exception {
        if (this.item != null) {
            this.item.dispose();
            this.item = null;
        }
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        return new MiloServerProducer((Endpoint)this, this.item);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MiloServerConsumer consumer = new MiloServerConsumer((Endpoint)this, processor, this.item);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemId() {
        return this.itemId;
    }
}

