/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.milo.KeyStoreLoader;
import org.apache.camel.component.milo.server.MiloServerEndpoint;
import org.apache.camel.component.milo.server.internal.CamelNamespace;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.AnonymousIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.security.DefaultCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="milo-server")
public class MiloServerComponent
extends DefaultComponent {
    public static final String DEFAULT_NAMESPACE_URI = "urn:org:apache:camel";
    private static final Logger LOG = LoggerFactory.getLogger(MiloServerComponent.class);
    private static final String URL_CHARSET = "UTF-8";
    private int port;
    private String namespaceUri = "urn:org:apache:camel";
    private OpcUaServerConfigBuilder opcServerConfig;
    private OpcUaServer server;
    private CamelNamespace namespace;
    private final Map<String, MiloServerEndpoint> endpoints = new HashMap<String, MiloServerEndpoint>();
    private Boolean enableAnonymousAuthentication;
    private CertificateManager certificateManager;
    private Set<SecurityPolicy> securityPolicies;
    private Map<String, String> userMap;
    private String usernameSecurityPolicyUri = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME.getSecurityPolicyUri();
    private List<String> bindAddresses;
    private Supplier<CertificateValidator> certificateValidator;
    private final List<Runnable> runOnStop = new LinkedList<Runnable>();
    private X509Certificate certificate;
    private String productUri;
    private String applicationUri;
    private String applicationName;
    private String path;
    private BuildInfo buildInfo;

    public MiloServerComponent() {
        this.opcServerConfig = null;
    }

    public MiloServerComponent(OpcUaServerConfig serverConfig) {
        this.opcServerConfig = OpcUaServerConfig.copy((OpcUaServerConfig)serverConfig);
    }

    protected void doStart() throws Exception {
        this.server = new OpcUaServer(this.buildServerConfig());
        this.namespace = new CamelNamespace(this.namespaceUri, this.server);
        this.namespace.startup();
        super.doStart();
        this.server.startup();
    }

    private OpcUaServerConfig buildServerConfig() {
        OpcUaServerConfigBuilder serverConfig;
        OpcUaServerConfigBuilder opcUaServerConfigBuilder = serverConfig = this.opcServerConfig != null ? this.opcServerConfig : this.createDefaultConfiguration();
        if (this.userMap != null || this.enableAnonymousAuthentication != null) {
            HashMap<String, String> userMap = this.userMap != null ? new HashMap<String, String>(this.userMap) : Collections.emptyMap();
            boolean allowAnonymous = Boolean.TRUE.equals(this.enableAnonymousAuthentication);
            UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(allowAnonymous, challenge -> {
                String pwd = (String)userMap.get(challenge.getUsername());
                if (pwd == null) {
                    return false;
                }
                return pwd.equals(challenge.getPassword());
            });
            serverConfig.setIdentityValidator((IdentityValidator)identityValidator);
            LinkedList<UserTokenPolicy> tokenPolicies = new LinkedList<UserTokenPolicy>();
            if (allowAnonymous) {
                tokenPolicies.add(OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS);
            }
            if (userMap != null) {
                tokenPolicies.add(this.getUsernamePolicy());
            }
            serverConfig.setEndpoints(this.createEndpointConfigurations(tokenPolicies));
        } else {
            serverConfig.setEndpoints(this.createEndpointConfigurations(null, this.securityPolicies));
        }
        if (this.certificateValidator != null) {
            CertificateValidator validator = this.certificateValidator.get();
            LOG.debug("Using validator: {}", (Object)validator);
            if (validator instanceof Closeable) {
                this.runOnStop(() -> {
                    try {
                        LOG.debug("Closing: {}", (Object)validator);
                        ((Closeable)validator).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close", (Throwable)e);
                    }
                });
            }
            serverConfig.setCertificateValidator(validator);
        }
        return serverConfig.build();
    }

    private OpcUaServerConfigBuilder createDefaultConfiguration() {
        OpcUaServerConfigBuilder cfg = OpcUaServerConfig.builder();
        cfg.setCertificateManager((CertificateManager)new DefaultCertificateManager());
        cfg.setCertificateValidator(DenyAllCertificateValidator.INSTANCE);
        cfg.setEndpoints(this.createEndpointConfigurations(null));
        cfg.setApplicationName(LocalizedText.english((String)(this.applicationName == null ? "Apache Camel Milo Server" : this.applicationName)));
        cfg.setApplicationUri("urn:org:apache:camel:milo:server");
        cfg.setProductUri("urn:org:apache:camel:milo");
        cfg.setCertificateManager(this.certificateManager);
        if (this.productUri != null) {
            cfg.setProductUri(this.productUri);
        }
        if (this.applicationUri != null) {
            cfg.setApplicationUri(this.applicationUri);
        }
        if (this.buildInfo != null) {
            cfg.setBuildInfo(this.buildInfo);
        }
        if (Boolean.getBoolean("org.apache.camel.milo.server.default.enableAnonymous")) {
            cfg.setIdentityValidator(AnonymousIdentityValidator.INSTANCE);
        }
        return cfg;
    }

    private Set<EndpointConfiguration> createEndpointConfigurations(List<UserTokenPolicy> userTokenPolicies) {
        return this.createEndpointConfigurations(userTokenPolicies, this.securityPolicies);
    }

    private Set<EndpointConfiguration> createEndpointConfigurations(List<UserTokenPolicy> userTokenPolicies, Set<SecurityPolicy> securityPolicies) {
        LinkedHashSet<EndpointConfiguration> endpointConfigurations = new LinkedHashSet<EndpointConfiguration>();
        if (this.bindAddresses == null) {
            return Collections.emptySet();
        }
        for (String bindAddress : this.bindAddresses) {
            UserTokenPolicy[] userTokenPolicyArray;
            boolean anonymous;
            LinkedHashSet<String> hostnames = new LinkedHashSet<String>();
            hostnames.add(HostnameUtil.getHostname());
            hostnames.addAll(HostnameUtil.getHostnames((String)bindAddress));
            boolean bl = anonymous = this.enableAnonymousAuthentication != null && this.enableAnonymousAuthentication != false || Boolean.getBoolean("org.apache.camel.milo.server.default.enableAnonymous");
            if (userTokenPolicies != null) {
                userTokenPolicyArray = userTokenPolicies.toArray(new UserTokenPolicy[userTokenPolicies.size()]);
            } else if (anonymous) {
                UserTokenPolicy[] userTokenPolicyArray2 = new UserTokenPolicy[3];
                userTokenPolicyArray2[0] = OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS;
                userTokenPolicyArray2[1] = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
                userTokenPolicyArray = userTokenPolicyArray2;
                userTokenPolicyArray2[2] = OpcUaServerConfig.USER_TOKEN_POLICY_X509;
            } else {
                UserTokenPolicy[] userTokenPolicyArray3 = new UserTokenPolicy[2];
                userTokenPolicyArray3[0] = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
                userTokenPolicyArray = userTokenPolicyArray3;
                userTokenPolicyArray3[1] = OpcUaServerConfig.USER_TOKEN_POLICY_X509;
            }
            UserTokenPolicy[] tokenPolicies = userTokenPolicyArray;
            for (String hostname : hostnames) {
                EndpointConfiguration.Builder builder = EndpointConfiguration.newBuilder().setBindAddress(bindAddress).setHostname(hostname).setCertificate(this.certificate).setPath(this.path == null ? "" : this.path).addTokenPolicies(tokenPolicies);
                if (securityPolicies == null || securityPolicies.contains(SecurityPolicy.None)) {
                    EndpointConfiguration.Builder noSecurityBuilder = builder.copy().setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                    endpointConfigurations.add(this.buildTcpEndpoint(noSecurityBuilder));
                    endpointConfigurations.add(this.buildHttpsEndpoint(noSecurityBuilder));
                } else if (securityPolicies.contains(SecurityPolicy.Basic256Sha256)) {
                    endpointConfigurations.add(this.buildTcpEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.SignAndEncrypt)));
                } else if (securityPolicies.contains(SecurityPolicy.Basic256Sha256)) {
                    endpointConfigurations.add(this.buildHttpsEndpoint(builder.copy().setSecurityPolicy(SecurityPolicy.Basic256Sha256).setSecurityMode(MessageSecurityMode.Sign)));
                }
                EndpointConfiguration.Builder discoveryBuilder = builder.copy().setPath("/discovery").setSecurityPolicy(SecurityPolicy.None).setSecurityMode(MessageSecurityMode.None);
                endpointConfigurations.add(this.buildTcpEndpoint(discoveryBuilder));
                endpointConfigurations.add(this.buildHttpsEndpoint(discoveryBuilder));
            }
        }
        return endpointConfigurations;
    }

    private EndpointConfiguration buildTcpEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.TCP_UASC_UABINARY).setBindPort(this.port).build();
    }

    private EndpointConfiguration buildHttpsEndpoint(EndpointConfiguration.Builder base) {
        return base.copy().setTransportProfile(TransportProfile.HTTPS_UABINARY).setBindPort(this.port).build();
    }

    private UserTokenPolicy getUsernamePolicy() {
        if (this.usernameSecurityPolicyUri == null || this.usernameSecurityPolicyUri.isEmpty()) {
            return OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
        }
        return new UserTokenPolicy("username", UserTokenType.UserName, null, null, this.usernameSecurityPolicyUri);
    }

    private void runOnStop(Runnable runnable) {
        this.runOnStop.add(runnable);
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
        }
        super.doStop();
        this.runOnStop.forEach(runnable -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.warn("Failed to run on stop", (Throwable)e);
            }
        });
        this.runOnStop.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloServerComponent miloServerComponent = this;
        synchronized (miloServerComponent) {
            if (remaining == null || remaining.isEmpty()) {
                return null;
            }
            MiloServerEndpoint endpoint = this.endpoints.get(remaining);
            if (endpoint == null) {
                endpoint = new MiloServerEndpoint(uri, remaining, this.namespace, (Component)this);
                this.setProperties((Endpoint)endpoint, parameters);
                this.endpoints.put(remaining, endpoint);
            }
            return endpoint;
        }
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public void setApplicationName(String applicationName) {
        Objects.requireNonNull(applicationName);
        this.applicationName = applicationName;
    }

    public void setPath(String path) {
        Objects.requireNonNull(path);
        this.path = path;
    }

    public void setApplicationUri(String applicationUri) {
        Objects.requireNonNull(applicationUri);
        this.applicationUri = applicationUri;
    }

    public void setProductUri(String productUri) {
        Objects.requireNonNull(productUri);
        this.productUri = productUri;
    }

    public void setBindPort(int port) {
        this.port = port;
    }

    public void setSecurityPolicies(Set<SecurityPolicy> securityPolicies) {
        this.securityPolicies = securityPolicies == null || securityPolicies.isEmpty() ? EnumSet.noneOf(SecurityPolicy.class) : EnumSet.copyOf(securityPolicies);
    }

    public void setSecurityPoliciesById(Collection<String> securityPolicies) {
        EnumSet<SecurityPolicy> policies = EnumSet.noneOf(SecurityPolicy.class);
        if (securityPolicies != null) {
            for (String policyName : securityPolicies) {
                SecurityPolicy policy = SecurityPolicy.fromUriSafe((String)policyName).orElseGet(() -> SecurityPolicy.valueOf((String)policyName));
                policies.add(policy);
            }
        }
        this.securityPolicies = policies;
    }

    public void setSecurityPoliciesById(String ... ids) {
        if (ids != null) {
            this.setSecurityPoliciesById(Arrays.asList(ids));
        } else {
            this.setSecurityPoliciesById((Collection<String>)null);
        }
    }

    public void setUserAuthenticationCredentials(String userAuthenticationCredentials) {
        if (userAuthenticationCredentials != null) {
            this.userMap = new HashMap<String, String>();
            for (String creds : userAuthenticationCredentials.split(",")) {
                String[] toks = creds.split(":", 2);
                if (toks.length != 2) continue;
                try {
                    this.userMap.put(URLDecoder.decode(toks[0], URL_CHARSET), URLDecoder.decode(toks[1], URL_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Failed to decode user map entry", (Throwable)e);
                }
            }
        } else {
            this.userMap = null;
        }
    }

    public void setEnableAnonymousAuthentication(boolean enableAnonymousAuthentication) {
        this.enableAnonymousAuthentication = enableAnonymousAuthentication;
    }

    public void setUsernameSecurityPolicyUri(SecurityPolicy usernameSecurityPolicy) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicy.getUri();
    }

    public void setUsernameSecurityPolicyUri(String usernameSecurityPolicyUri) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicyUri;
    }

    public void setBindAddresses(String bindAddresses) {
        this.bindAddresses = bindAddresses != null ? Arrays.asList(bindAddresses.split(",")) : null;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public void setServerCertificate(KeyStoreLoader.Result result) {
        Objects.requireNonNull(result, "Setting a null is not supported. call setCertificateManager(null) instead.)");
        this.setServerCertificate(result.getKeyPair(), result.getCertificate());
    }

    public void setServerCertificate(KeyPair keyPair, X509Certificate certificate) {
        this.certificate = certificate;
        this.setCertificateManager((CertificateManager)new DefaultCertificateManager(keyPair, certificate));
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager != null ? certificateManager : new DefaultCertificateManager();
    }

    public void setCertificateValidator(Supplier<CertificateValidator> certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public void setDefaultCertificateValidator(File certificatesBaseDir) {
        try {
            DefaultTrustListManager trustListManager = new DefaultTrustListManager(certificatesBaseDir);
            this.certificateValidator = () -> new DefaultCertificateValidator((TrustListManager)trustListManager);
        }
        catch (IOException e) {
            LOG.error("Failed to construct certificateValidator.", (Throwable)e);
        }
    }

    private static final class DenyAllCertificateValidator
    implements CertificateValidator {
        public static final CertificateValidator INSTANCE = new DenyAllCertificateValidator();

        private DenyAllCertificateValidator() {
        }

        public void validate(X509Certificate certificate) throws UaException {
            throw new UaException(0x80180000L);
        }

        public void verifyTrustChain(List<X509Certificate> certificateChain) throws UaException {
            throw new UaException(0x80180000L);
        }
    }
}

