/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.meta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.Filters;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.component.extension.metadata.AbstractMetaDataExtension;
import org.apache.camel.component.extension.metadata.MetaDataBuilder;
import org.apache.camel.component.mongodb.conf.ConnectionParamsConfiguration;
import org.apache.camel.util.CastUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBMetaExtension
extends AbstractMetaDataExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBMetaExtension.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    public MongoDBMetaExtension() {
        this(null);
    }

    public MongoDBMetaExtension(CamelContext context) {
        super(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<MetaDataExtension.MetaData> meta(Map<String, Object> parameters) {
        JsonNode collectionInfoRoot;
        Map textParameters = CastUtils.cast(parameters);
        LOGGER.debug("Fetching mongodb meta information with params: {}", (Object)textParameters);
        ConnectionParamsConfiguration mongoConf = new ConnectionParamsConfiguration(textParameters);
        MongoClientURI connectionURI = new MongoClientURI(mongoConf.getMongoClientURI());
        try (MongoClient mongoConnection = MongoClients.create((String)connectionURI.getURI());){
            Document collectionInfo = (Document)mongoConnection.getDatabase((String)textParameters.get("database")).listCollections().filter(Filters.eq((String)"name", textParameters.get("collection"))).first();
            LOGGER.debug("Collection info: {}", (Object)collectionInfo);
            if (collectionInfo == null) {
                LOGGER.error("Cannot read information for collection {}.{}", textParameters.get("database"), textParameters.get("collection"));
                Optional<MetaDataExtension.MetaData> optional = Optional.empty();
                return optional;
            }
            String collectionInfoJson = collectionInfo.toJson();
            collectionInfoRoot = this.objectMapper.readTree(collectionInfoJson.replace("bsonType", "type"));
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while reading schema information", (Throwable)e);
            return Optional.empty();
        }
        JsonNode schemaRoot = collectionInfoRoot.path("options").path("validator").path("$jsonSchema");
        if (!schemaRoot.isMissingNode()) {
            ObjectNode root = (ObjectNode)schemaRoot;
            root.put("$schema", "http://json-schema.org/schema#");
            root.put("id", String.format("urn:jsonschema:%s:%s:%s)", "org:apache:camel:component:mongodb", textParameters.get("database"), textParameters.get("collection")));
            return Optional.of(MetaDataBuilder.on((CamelContext)this.getCamelContext()).withAttribute("Content-Type", (Object)"application/schema+json").withAttribute("Java-Type", JsonNode.class).withPayload((Object)root).build());
        }
        LOGGER.warn("Cannot retrieve info for : {}.{} collection. Likely the collection has not been provided with a validator", textParameters.get("database"), textParameters.get("collection"));
        return Optional.empty();
    }
}

