/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.processor.idempotent.jpa.MessageProcessed;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(description="JPA based message id repository")
public class JpaMessageIdRepository
extends ServiceSupport
implements IdempotentRepository {
    protected static final String QUERY_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1 and x.messageId = ?2";
    protected static final String QUERY_CLEAR_STRING = "select x from " + MessageProcessed.class.getName() + " x where x.processorName = ?1";
    private static final Logger LOG = LoggerFactory.getLogger(JpaMessageIdRepository.class);
    private final String processorName;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionTemplate transactionTemplate;
    private boolean joinTransaction = true;
    private boolean sharedEntityManager;

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        this(entityManagerFactory, JpaMessageIdRepository.createTransactionTemplate(entityManagerFactory), processorName);
    }

    public JpaMessageIdRepository(EntityManagerFactory entityManagerFactory, TransactionTemplate transactionTemplate, String processorName) {
        this.entityManagerFactory = entityManagerFactory;
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(String persistenceUnit, String processorName) {
        return JpaMessageIdRepository.jpaMessageIdRepository(Persistence.createEntityManagerFactory((String)persistenceUnit), processorName);
    }

    public static JpaMessageIdRepository jpaMessageIdRepository(EntityManagerFactory entityManagerFactory, String processorName) {
        return new JpaMessageIdRepository(entityManagerFactory, processorName);
    }

    private static TransactionTemplate createTransactionTemplate(EntityManagerFactory entityManagerFactory) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new JpaTransactionManager(entityManagerFactory));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String messageId) {
        return this.add(null, messageId);
    }

    public boolean add(Exchange exchange, final String messageId) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true, this.sharedEntityManager, true);
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                try {
                    List list = JpaMessageIdRepository.this.query(entityManager, messageId);
                    if (list.isEmpty()) {
                        MessageProcessed processed = new MessageProcessed();
                        processed.setProcessorName(JpaMessageIdRepository.this.processorName);
                        processed.setMessageId(messageId);
                        processed.setCreatedAt(new Date());
                        entityManager.persist((Object)processed);
                        entityManager.flush();
                        entityManager.close();
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                catch (Exception ex) {
                    LOG.error("Something went wrong trying to add message to repository {}", (Throwable)ex);
                    throw new PersistenceException((Throwable)ex);
                }
                finally {
                    try {
                        if (entityManager.isOpen()) {
                            entityManager.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        LOG.debug("add {} -> {}", (Object)messageId, (Object)rc);
        return rc;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String messageId) {
        return this.contains(null, messageId);
    }

    public boolean contains(Exchange exchange, final String messageId) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true, this.sharedEntityManager, true);
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                List list;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                if ((list = JpaMessageIdRepository.this.query(entityManager, messageId)).isEmpty()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        LOG.debug("contains {} -> {}", (Object)messageId, (Object)rc);
        return rc;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String messageId) {
        return this.remove(null, messageId);
    }

    public boolean remove(Exchange exchange, final String messageId) {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, true, this.sharedEntityManager, true);
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                Boolean bl;
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                try {
                    List list = JpaMessageIdRepository.this.query(entityManager, messageId);
                    if (list.isEmpty()) {
                        Boolean bl2 = Boolean.FALSE;
                        return bl2;
                    }
                    MessageProcessed processed = (MessageProcessed)list.get(0);
                    entityManager.remove((Object)processed);
                    entityManager.flush();
                    entityManager.close();
                    bl = Boolean.TRUE;
                }
                catch (Exception ex) {
                    LOG.error("Something went wrong trying to remove message to repository {}", (Throwable)ex);
                    throw new PersistenceException((Throwable)ex);
                }
                finally {
                    try {
                        if (entityManager.isOpen()) {
                            entityManager.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                return bl;
            }
        });
        LOG.debug("remove {}", (Object)messageId);
        return rc;
    }

    public boolean confirm(String messageId) {
        return this.confirm(null, messageId);
    }

    public boolean confirm(Exchange exchange, String messageId) {
        LOG.debug("confirm {} -> true", (Object)messageId);
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        final EntityManager entityManager = JpaHelper.getTargetEntityManager(null, this.entityManagerFactory, true, this.sharedEntityManager, true);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                if (JpaMessageIdRepository.this.isJoinTransaction()) {
                    entityManager.joinTransaction();
                }
                try {
                    List list = JpaMessageIdRepository.this.queryClear(entityManager);
                    if (!list.isEmpty()) {
                        for (Object item : list) {
                            entityManager.remove(item);
                        }
                        entityManager.flush();
                        entityManager.close();
                    }
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                catch (Exception ex) {
                    LOG.error("Something went wrong trying to clear the repository {}", (Throwable)ex);
                    throw new PersistenceException((Throwable)ex);
                }
                finally {
                    try {
                        if (entityManager.isOpen()) {
                            entityManager.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        LOG.debug("clear the store {}", (Object)MessageProcessed.class.getName());
    }

    private List<?> query(EntityManager entityManager, String messageId) {
        Query query = entityManager.createQuery(QUERY_STRING);
        query.setParameter(1, (Object)this.processorName);
        query.setParameter(2, (Object)messageId);
        return query.getResultList();
    }

    private List<?> queryClear(EntityManager entityManager) {
        Query query = entityManager.createQuery(QUERY_CLEAR_STRING);
        query.setParameter(1, (Object)this.processorName);
        return query.getResultList();
    }

    @ManagedAttribute(description="The processor name")
    public String getProcessorName() {
        return this.processorName;
    }

    @ManagedAttribute(description="Whether to join existing transaction")
    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    @ManagedAttribute(description="Whether to use shared EntityManager")
    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

