/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The Facebook component provides access to all of the Facebook APIs accessible
 * using Facebook4J. It allows producing messages to retrieve, add, and delete
 * posts, likes, comments, photos, albums, videos, photos, checkins, locations,
 * links, etc. It also supports APIs that allow polling for posts, users,
 * checkins, groups, locations, etc.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FacebookEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Facebook component.
     */
    public interface FacebookEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFacebookEndpointConsumerBuilder advanced() {
            return (AdvancedFacebookEndpointConsumerBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder achievementURL(
                URL achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder achievementURL(
                String achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder albumId(String albumId) {
            doSetProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: <code>facebook4j.AlbumUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder albumUpdate(Object albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.AlbumUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder albumUpdate(String albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder appId(String appId) {
            doSetProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: <code>facebook4j.GeoLocation</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder center(Object center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a <code>facebook4j.GeoLocation</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder center(String center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder checkinId(String checkinId) {
            doSetProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointConsumerBuilder checkinUpdate(
                Object checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointConsumerBuilder checkinUpdate(
                String checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder clientURL(String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder clientVersion(
                String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder commentId(String commentId) {
            doSetProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder commentUpdate(
                Object commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder commentUpdate(
                String commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder debugEnabled(
                Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder debugEnabled(String debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder distance(Integer distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder distance(String distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainId(String domainId) {
            doSetProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainNames(
                List<String> domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainNames(String domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: <code>facebook4j.EventUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder eventUpdate(Object eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.EventUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder eventUpdate(String eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendId(String friendId) {
            doSetProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendlistId(String friendlistId) {
            doSetProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendlistName(
                String friendlistName) {
            doSetProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendUserId(String friendUserId) {
            doSetProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointConsumerBuilder gzipEnabled(Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointConsumerBuilder gzipEnabled(String gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20000
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 20000
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 2
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 20
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 120000
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpReadTimeout(
                Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 120000
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpReadTimeout(
                String httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryCount(
                Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 0
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryCount(
                String httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 40000
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 40000
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder ids(List<String> ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder includeRead(Boolean includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder includeRead(String includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder isHidden(Boolean isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder isHidden(String isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder jsonStoreEnabled(
                String jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder link(URL link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder link(String link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder linkId(String linkId) {
            doSetProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder locale(Locale locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder locale(String locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder mbeanEnabled(
                Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder mbeanEnabled(String mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder message(String message) {
            doSetProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder metric(String metric) {
            doSetProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder milestoneId(String milestoneId) {
            doSetProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder noteId(String noteId) {
            doSetProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder notificationId(
                String notificationId) {
            doSetProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder objectId(String objectId) {
            doSetProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder offerId(String offerId) {
            doSetProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder optionDescription(
                String optionDescription) {
            doSetProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pageId(String pageId) {
            doSetProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder permissionName(
                String permissionName) {
            doSetProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder permissions(String permissions) {
            doSetProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder photoId(String photoId) {
            doSetProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId(Integer pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId(String pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId2(Integer pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId2(String pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureSize(
                PictureSize pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureSize(String pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder placeId(String placeId) {
            doSetProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder postId(String postId) {
            doSetProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: <code>facebook4j.PostUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder postUpdate(Object postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a <code>facebook4j.PostUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder postUpdate(String postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointConsumerBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder queries(
                Map<String, String> queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder queries(String queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder questionId(String questionId) {
            doSetProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: <code>facebook4j.Reading</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder reading(Object reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a <code>facebook4j.Reading</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder reading(String reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder readingOptions(
                Map<String, Object> readingOptions) {
            doSetProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder readingOptions(
                String readingOptions) {
            doSetProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         */
        default FacebookEndpointConsumerBuilder restBaseURL(String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder scoreValue(Integer scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder scoreValue(String scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder size(PictureSize size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder source(Object source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder tabId(String tabId) {
            doSetProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: <code>facebook4j.TagUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder tagUpdate(Object tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a <code>facebook4j.TagUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder tagUpdate(String tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser1(Object testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser1(String testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser2(Object testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser2(String testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUserId(String testUserId) {
            doSetProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder title(String title) {
            doSetProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder toUserId(String toUserId) {
            doSetProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder toUserIds(List<String> toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder toUserIds(String toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userId1(String userId1) {
            doSetProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userId2(String userId2) {
            doSetProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userIds(List<String> userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userIds(String userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userLocale(String userLocale) {
            doSetProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointConsumerBuilder useSSL(Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointConsumerBuilder useSSL(String useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         */
        default FacebookEndpointConsumerBuilder videoBaseURL(String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder videoId(String videoId) {
            doSetProperty("videoId", videoId);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default FacebookEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default FacebookEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyHost(
                String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyPort(
                Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyPort(
                String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyUser(
                String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAccessToken(
                String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAppId(String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAppSecret(
                String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthPermissions(
                String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Facebook component.
     */
    public interface AdvancedFacebookEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FacebookEndpointConsumerBuilder basic() {
            return (FacebookEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Facebook component.
     */
    public interface FacebookEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFacebookEndpointProducerBuilder advanced() {
            return (AdvancedFacebookEndpointProducerBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder achievementURL(
                URL achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder achievementURL(
                String achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder albumId(String albumId) {
            doSetProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: <code>facebook4j.AlbumUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder albumUpdate(Object albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.AlbumUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder albumUpdate(String albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder appId(String appId) {
            doSetProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: <code>facebook4j.GeoLocation</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder center(Object center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a <code>facebook4j.GeoLocation</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder center(String center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder checkinId(String checkinId) {
            doSetProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointProducerBuilder checkinUpdate(
                Object checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointProducerBuilder checkinUpdate(
                String checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder clientURL(String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder clientVersion(
                String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder commentId(String commentId) {
            doSetProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder commentUpdate(
                Object commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder commentUpdate(
                String commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder debugEnabled(
                Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder debugEnabled(String debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder distance(Integer distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder distance(String distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainId(String domainId) {
            doSetProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainNames(
                List<String> domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainNames(String domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: <code>facebook4j.EventUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder eventUpdate(Object eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.EventUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder eventUpdate(String eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendId(String friendId) {
            doSetProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendlistId(String friendlistId) {
            doSetProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendlistName(
                String friendlistName) {
            doSetProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendUserId(String friendUserId) {
            doSetProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointProducerBuilder gzipEnabled(Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointProducerBuilder gzipEnabled(String gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20000
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 20000
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 2
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 20
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 120000
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpReadTimeout(
                Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 120000
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpReadTimeout(
                String httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryCount(
                Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 0
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryCount(
                String httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 40000
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 40000
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder ids(List<String> ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder includeRead(Boolean includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder includeRead(String includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder isHidden(Boolean isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder isHidden(String isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder jsonStoreEnabled(
                String jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder link(URL link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder link(String link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder linkId(String linkId) {
            doSetProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder locale(Locale locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder locale(String locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder mbeanEnabled(
                Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder mbeanEnabled(String mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder message(String message) {
            doSetProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder metric(String metric) {
            doSetProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder milestoneId(String milestoneId) {
            doSetProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder noteId(String noteId) {
            doSetProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder notificationId(
                String notificationId) {
            doSetProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder objectId(String objectId) {
            doSetProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder offerId(String offerId) {
            doSetProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder optionDescription(
                String optionDescription) {
            doSetProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pageId(String pageId) {
            doSetProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder permissionName(
                String permissionName) {
            doSetProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder permissions(String permissions) {
            doSetProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder photoId(String photoId) {
            doSetProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId(Integer pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId(String pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId2(Integer pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId2(String pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureSize(
                PictureSize pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureSize(String pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder placeId(String placeId) {
            doSetProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder postId(String postId) {
            doSetProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: <code>facebook4j.PostUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder postUpdate(Object postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a <code>facebook4j.PostUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder postUpdate(String postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointProducerBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder queries(
                Map<String, String> queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder queries(String queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder questionId(String questionId) {
            doSetProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: <code>facebook4j.Reading</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder reading(Object reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a <code>facebook4j.Reading</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder reading(String reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder readingOptions(
                Map<String, Object> readingOptions) {
            doSetProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder readingOptions(
                String readingOptions) {
            doSetProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         */
        default FacebookEndpointProducerBuilder restBaseURL(String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder scoreValue(Integer scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder scoreValue(String scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder size(PictureSize size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder source(Object source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder tabId(String tabId) {
            doSetProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: <code>facebook4j.TagUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder tagUpdate(Object tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a <code>facebook4j.TagUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder tagUpdate(String tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser1(Object testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser1(String testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser2(Object testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser2(String testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUserId(String testUserId) {
            doSetProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder title(String title) {
            doSetProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder toUserId(String toUserId) {
            doSetProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder toUserIds(List<String> toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder toUserIds(String toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userId1(String userId1) {
            doSetProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userId2(String userId2) {
            doSetProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userIds(List<String> userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userIds(String userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userLocale(String userLocale) {
            doSetProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointProducerBuilder useSSL(Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointProducerBuilder useSSL(String useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         */
        default FacebookEndpointProducerBuilder videoBaseURL(String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder videoId(String videoId) {
            doSetProperty("videoId", videoId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default FacebookEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default FacebookEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyHost(
                String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyPort(
                Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyPort(
                String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyUser(
                String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAccessToken(
                String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAppId(String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAppSecret(
                String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthPermissions(
                String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Facebook component.
     */
    public interface AdvancedFacebookEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FacebookEndpointProducerBuilder basic() {
            return (FacebookEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Facebook component.
     */
    public interface FacebookEndpointBuilder
            extends
                FacebookEndpointConsumerBuilder,
                FacebookEndpointProducerBuilder {
        default AdvancedFacebookEndpointBuilder advanced() {
            return (AdvancedFacebookEndpointBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder achievementURL(URL achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder achievementURL(String achievementURL) {
            doSetProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder albumId(String albumId) {
            doSetProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: <code>facebook4j.AlbumUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder albumUpdate(Object albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.AlbumUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder albumUpdate(String albumUpdate) {
            doSetProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder appId(String appId) {
            doSetProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: <code>facebook4j.GeoLocation</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder center(Object center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a <code>facebook4j.GeoLocation</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder center(String center) {
            doSetProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder checkinId(String checkinId) {
            doSetProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointBuilder checkinUpdate(Object checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointBuilder checkinUpdate(String checkinUpdate) {
            doSetProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder clientURL(String clientURL) {
            doSetProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder clientVersion(String clientVersion) {
            doSetProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder commentId(String commentId) {
            doSetProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder commentUpdate(Object commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder commentUpdate(String commentUpdate) {
            doSetProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder debugEnabled(Boolean debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder debugEnabled(String debugEnabled) {
            doSetProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder distance(Integer distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder distance(String distance) {
            doSetProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainId(String domainId) {
            doSetProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainNames(List<String> domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainNames(String domainNames) {
            doSetProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder eventId(String eventId) {
            doSetProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: <code>facebook4j.EventUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder eventUpdate(Object eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.EventUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder eventUpdate(String eventUpdate) {
            doSetProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendId(String friendId) {
            doSetProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendlistId(String friendlistId) {
            doSetProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendlistName(String friendlistName) {
            doSetProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendUserId(String friendUserId) {
            doSetProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder groupId(String groupId) {
            doSetProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointBuilder gzipEnabled(Boolean gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointBuilder gzipEnabled(String gzipEnabled) {
            doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20000
         * Group: common
         */
        default FacebookEndpointBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 20000
         * Group: common
         */
        default FacebookEndpointBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default FacebookEndpointBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 2
         * Group: common
         */
        default FacebookEndpointBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 20
         * Group: common
         */
        default FacebookEndpointBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 20
         * Group: common
         */
        default FacebookEndpointBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 120000
         * Group: common
         */
        default FacebookEndpointBuilder httpReadTimeout(Integer httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 120000
         * Group: common
         */
        default FacebookEndpointBuilder httpReadTimeout(String httpReadTimeout) {
            doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryCount(Integer httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 0
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryCount(String httpRetryCount) {
            doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 5
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 5
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 40000
         * Group: common
         */
        default FacebookEndpointBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 40000
         * Group: common
         */
        default FacebookEndpointBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder ids(List<String> ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder ids(String ids) {
            doSetProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder includeRead(Boolean includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder includeRead(String includeRead) {
            doSetProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder isHidden(Boolean isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder isHidden(String isHidden) {
            doSetProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder jsonStoreEnabled(String jsonStoreEnabled) {
            doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder link(URL link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder link(String link) {
            doSetProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder linkId(String linkId) {
            doSetProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder locale(Locale locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder locale(String locale) {
            doSetProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder mbeanEnabled(Boolean mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder mbeanEnabled(String mbeanEnabled) {
            doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder message(String message) {
            doSetProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder metric(String metric) {
            doSetProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder milestoneId(String milestoneId) {
            doSetProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder noteId(String noteId) {
            doSetProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder notificationId(String notificationId) {
            doSetProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder objectId(String objectId) {
            doSetProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder offerId(String offerId) {
            doSetProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder optionDescription(
                String optionDescription) {
            doSetProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pageId(String pageId) {
            doSetProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder permissionName(String permissionName) {
            doSetProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder permissions(String permissions) {
            doSetProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder photoId(String photoId) {
            doSetProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId(Integer pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId(String pictureId) {
            doSetProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId2(Integer pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId2(String pictureId2) {
            doSetProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureSize(PictureSize pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureSize(String pictureSize) {
            doSetProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder placeId(String placeId) {
            doSetProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder postId(String postId) {
            doSetProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: <code>facebook4j.PostUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder postUpdate(Object postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a <code>facebook4j.PostUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder postUpdate(String postUpdate) {
            doSetProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: false
         * Group: common
         */
        default FacebookEndpointBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder queries(Map<String, String> queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder queries(String queries) {
            doSetProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder questionId(String questionId) {
            doSetProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: <code>facebook4j.Reading</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder reading(Object reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a <code>facebook4j.Reading</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder reading(String reading) {
            doSetProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder readingOptions(
                Map<String, Object> readingOptions) {
            doSetProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder readingOptions(String readingOptions) {
            doSetProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph.facebook.com/
         * Group: common
         */
        default FacebookEndpointBuilder restBaseURL(String restBaseURL) {
            doSetProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder scoreValue(Integer scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder scoreValue(String scoreValue) {
            doSetProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder size(PictureSize size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder size(String size) {
            doSetProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder source(Object source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder source(String source) {
            doSetProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder tabId(String tabId) {
            doSetProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: <code>facebook4j.TagUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder tagUpdate(Object tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a <code>facebook4j.TagUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder tagUpdate(String tagUpdate) {
            doSetProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser1(Object testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser1(String testUser1) {
            doSetProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser2(Object testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser2(String testUser2) {
            doSetProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUserId(String testUserId) {
            doSetProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder title(String title) {
            doSetProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder toUserId(String toUserId) {
            doSetProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder toUserIds(List<String> toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder toUserIds(String toUserIds) {
            doSetProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userId(String userId) {
            doSetProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userId1(String userId1) {
            doSetProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userId2(String userId2) {
            doSetProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userIds(List<String> userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userIds(String userIds) {
            doSetProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userLocale(String userLocale) {
            doSetProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointBuilder useSSL(Boolean useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Default: true
         * Group: common
         */
        default FacebookEndpointBuilder useSSL(String useSSL) {
            doSetProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph-video.facebook.com/
         * Group: common
         */
        default FacebookEndpointBuilder videoBaseURL(String videoBaseURL) {
            doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder videoId(String videoId) {
            doSetProperty("videoId", videoId);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyHost(String httpProxyHost) {
            doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyPassword(
                String httpProxyPassword) {
            doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyPort(Integer httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyPort(String httpProxyPort) {
            doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyUser(String httpProxyUser) {
            doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAccessToken(String oAuthAccessToken) {
            doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://graph.facebook.com/oauth/access_token
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAppId(String oAuthAppId) {
            doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAppSecret(String oAuthAppSecret) {
            doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://www.facebook.com/dialog/oauth
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthPermissions(String oAuthPermissions) {
            doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Facebook component.
     */
    public interface AdvancedFacebookEndpointBuilder
            extends
                AdvancedFacebookEndpointConsumerBuilder,
                AdvancedFacebookEndpointProducerBuilder {
        default FacebookEndpointBuilder basic() {
            return (FacebookEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>facebook4j.PictureSize</code> enum.
     */
    enum PictureSize {
        square,
        small,
        normal,
        large,
        thumbnail,
        album;
    }

    public interface FacebookBuilders {
        /**
         * Facebook (camel-facebook)
         * The Facebook component provides access to all of the Facebook APIs
         * accessible using Facebook4J. It allows producing messages to
         * retrieve, add, and delete posts, likes, comments, photos, albums,
         * videos, photos, checkins, locations, links, etc. It also supports
         * APIs that allow polling for posts, users, checkins, groups,
         * locations, etc.
         * 
         * Category: social
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-facebook
         * 
         * Syntax: <code>facebook:methodName</code>
         * 
         * Path parameter: methodName (required)
         * What operation to perform
         */
        default FacebookEndpointBuilder facebook(String path) {
            return FacebookEndpointBuilderFactory.facebook(path);
        }
    }
    /**
     * Facebook (camel-facebook)
     * The Facebook component provides access to all of the Facebook APIs
     * accessible using Facebook4J. It allows producing messages to retrieve,
     * add, and delete posts, likes, comments, photos, albums, videos, photos,
     * checkins, locations, links, etc. It also supports APIs that allow polling
     * for posts, users, checkins, groups, locations, etc.
     * 
     * Category: social
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     * 
     * Syntax: <code>facebook:methodName</code>
     * 
     * Path parameter: methodName (required)
     * What operation to perform
     */
    static FacebookEndpointBuilder facebook(String path) {
        class FacebookEndpointBuilderImpl extends AbstractEndpointBuilder implements FacebookEndpointBuilder, AdvancedFacebookEndpointBuilder {
            public FacebookEndpointBuilderImpl(String path) {
                super("facebook", path);
            }
        }
        return new FacebookEndpointBuilderImpl(path);
    }
}