/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ddbstream.Ddb2StreamComponent;

/**
 * The aws2-ddbstream component is used for working with Amazon DynamoDB
 * Streams.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface Aws2DdbstreamComponentBuilderFactory {

    /**
     * AWS 2 DynamoDB Streams (camel-aws2-ddb)
     * The aws2-ddbstream component is used for working with Amazon DynamoDB
     * Streams.
     * 
     * Category: cloud,messaging,streams
     * Since: 3.1
     * Maven coordinates: org.apache.camel:camel-aws2-ddb
     */
    static Aws2DdbstreamComponentBuilder aws2Ddbstream() {
        return new Aws2DdbstreamComponentBuilderImpl();
    }

    /**
     * Builder for the AWS 2 DynamoDB Streams component.
     */
    interface Aws2DdbstreamComponentBuilder
            extends
                ComponentBuilder<Ddb2StreamComponent> {
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default Aws2DdbstreamComponentBuilder accessKey(
                java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default Aws2DdbstreamComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Amazon AWS Region.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default Aws2DdbstreamComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default Aws2DdbstreamComponentBuilder secretKey(
                java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default Aws2DdbstreamComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The AWS DDB stream default configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration</code> type.
         * 
         * Group: advanced
         */
        default Aws2DdbstreamComponentBuilder configuration(
                org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    }

    class Aws2DdbstreamComponentBuilderImpl
            extends
                AbstractComponentBuilder<Ddb2StreamComponent>
            implements
                Aws2DdbstreamComponentBuilder {
        @Override
        protected Ddb2StreamComponent buildConcreteComponent() {
            return new Ddb2StreamComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "accessKey": ((Ddb2StreamComponent) component).setAccessKey((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((Ddb2StreamComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "region": ((Ddb2StreamComponent) component).setRegion((java.lang.String) value); return true;
            case "secretKey": ((Ddb2StreamComponent) component).setSecretKey((java.lang.String) value); return true;
            case "basicPropertyBinding": ((Ddb2StreamComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "configuration": ((Ddb2StreamComponent) component).setConfiguration((org.apache.camel.component.aws2.ddbstream.Ddb2StreamConfiguration) value); return true;
            default: return false;
            }
        }
    }
}