/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapComponent;

/**
 * The atomix-multimap component is used to access Atomix's distributed multi
 * map.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface AtomixMultimapComponentBuilderFactory {

    /**
     * Atomix MultiMap (camel-atomix)
     * The atomix-multimap component is used to access Atomix's distributed
     * multi map.
     * 
     * Category: clustering
     * Since: 2.20
     * Maven coordinates: org.apache.camel:camel-atomix
     */
    static AtomixMultimapComponentBuilder atomixMultimap() {
        return new AtomixMultimapComponentBuilderImpl();
    }

    /**
     * Builder for the Atomix MultiMap component.
     */
    interface AtomixMultimapComponentBuilder
            extends
                ComponentBuilder<AtomixMultiMapComponent> {
        /**
         * The shared AtomixClient instance.
         * 
         * The option is a: <code>io.atomix.AtomixClient</code> type.
         * 
         * Group: producer
         */
        default AtomixMultimapComponentBuilder atomix(
                io.atomix.AtomixClient atomix) {
            doSetProperty("atomix", atomix);
            return this;
        }
        /**
         * The shared component configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration</code> type.
         * 
         * Group: producer
         */
        default AtomixMultimapComponentBuilder configuration(
                org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * The path to the AtomixClient configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AtomixMultimapComponentBuilder configurationUri(
                java.lang.String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default AtomixMultimapComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The nodes the AtomixClient should connect to.
         * 
         * The option is a:
         * <code>java.util.List<io.atomix.catalyst.transport.Address></code>
         * type.
         * 
         * Group: producer
         */
        default AtomixMultimapComponentBuilder nodes(
                java.util.List<io.atomix.catalyst.transport.Address> nodes) {
            doSetProperty("nodes", nodes);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AtomixMultimapComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }

    class AtomixMultimapComponentBuilderImpl
            extends
                AbstractComponentBuilder<AtomixMultiMapComponent>
            implements
                AtomixMultimapComponentBuilder {
        @Override
        protected AtomixMultiMapComponent buildConcreteComponent() {
            return new AtomixMultiMapComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "atomix": ((AtomixMultiMapComponent) component).setAtomix((io.atomix.AtomixClient) value); return true;
            case "configuration": ((AtomixMultiMapComponent) component).setConfiguration((org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration) value); return true;
            case "configurationUri": ((AtomixMultiMapComponent) component).setConfigurationUri((java.lang.String) value); return true;
            case "lazyStartProducer": ((AtomixMultiMapComponent) component).setLazyStartProducer((boolean) value); return true;
            case "nodes": ((AtomixMultiMapComponent) component).setNodes((java.util.List<io.atomix.catalyst.transport.Address>) value); return true;
            case "basicPropertyBinding": ((AtomixMultiMapComponent) component).setBasicPropertyBinding((boolean) value); return true;
            default: return false;
            }
        }
    }
}