/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.servicenow.ServiceNowComponentVerifierExtension;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowMetaDataExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;

@Metadata(label="verifiers", enums="parameters,connectivity")
@Component(value="servicenow")
public class ServiceNowComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private String instanceName;
    @Metadata(label="advanced")
    private ServiceNowConfiguration configuration = new ServiceNowConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public ServiceNowComponent() {
        this(null);
    }

    public ServiceNowComponent(CamelContext camelContext) {
        super(camelContext);
        this.registerExtension(ServiceNowComponentVerifierExtension::new);
        this.registerExtension(ServiceNowMetaDataExtension::new);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ServiceNowConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceNowConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getApiUrl() {
        return this.configuration.getApiUrl();
    }

    public void setApiUrl(String apiUrl) {
        this.configuration.setApiUrl(apiUrl);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    @Metadata(label="security", secret=true)
    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    @Metadata(label="security", secret=true)
    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public String getOauthClientId() {
        return this.configuration.getOauthClientId();
    }

    @Metadata(label="security", secret=true)
    public void setOauthClientId(String oauthClientId) {
        this.configuration.setOauthClientId(oauthClientId);
    }

    public String getOauthClientSecret() {
        return this.configuration.getOauthClientSecret();
    }

    @Metadata(label="security", secret=true)
    public void setOauthClientSecret(String oauthClientSecret) {
        this.configuration.setOauthClientSecret(oauthClientSecret);
    }

    public String getOauthTokenUrl() {
        return this.configuration.getOauthTokenUrl();
    }

    @Metadata(label="security", secret=true)
    public void setOauthTokenUrl(String oauthTokenUrl) {
        this.configuration.setOauthTokenUrl(oauthTokenUrl);
    }

    public String getProxyHost() {
        return this.configuration.getProxyHost();
    }

    @Metadata(label="advanced")
    public void setProxyHost(String proxyHost) {
        this.configuration.setProxyHost(proxyHost);
    }

    public Integer getProxyPort() {
        return this.configuration.getProxyPort();
    }

    @Metadata(label="advanced")
    public void setProxyPort(Integer proxyPort) {
        this.configuration.setProxyPort(proxyPort);
    }

    public String getProxyUserName() {
        return this.configuration.getProxyUserName();
    }

    @Metadata(label="advanced,security", secret=true)
    public void setProxyUserName(String proxyUserName) {
        this.configuration.setProxyUserName(proxyUserName);
    }

    public String getProxyPassword() {
        return this.configuration.getProxyPassword();
    }

    @Metadata(label="advanced,security", secret=true)
    public void setProxyPassword(String proxyPassword) {
        this.configuration.setProxyPassword(proxyPassword);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public ComponentVerifierExtension getVerifier() {
        return (scope, parameters) -> ((ComponentVerifierExtension)this.getExtension(ComponentVerifierExtension.class).orElseThrow(UnsupportedOperationException::new)).verify(scope, parameters);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CamelContext context = this.getCamelContext();
        ServiceNowConfiguration configuration = this.configuration.copy();
        Map models = PropertiesHelper.extractProperties(parameters, (String)"model.");
        for (Map.Entry entry : models.entrySet()) {
            configuration.addModel((String)entry.getKey(), (Class)EndpointHelper.resolveParameter((CamelContext)context, (String)((String)entry.getValue()), Class.class));
        }
        Map requestModels = PropertiesHelper.extractProperties(parameters, (String)"requestModel.");
        for (Map.Entry entry : requestModels.entrySet()) {
            configuration.addRequestModel((String)entry.getKey(), (Class)EndpointHelper.resolveParameter((CamelContext)context, (String)((String)entry.getValue()), Class.class));
        }
        Map map = PropertiesHelper.extractProperties(parameters, (String)"responseModel.");
        for (Map.Entry entry : map.entrySet()) {
            configuration.addResponseModel((String)entry.getKey(), (Class)EndpointHelper.resolveParameter((CamelContext)context, (String)((String)entry.getValue()), Class.class));
        }
        this.setProperties(configuration, parameters);
        if (ObjectHelper.isEmpty((Object)remaining)) {
            remaining = this.instanceName;
        }
        String string = this.getCamelContext().resolvePropertyPlaceholders(remaining);
        if (!configuration.hasApiUrl()) {
            configuration.setApiUrl(String.format("https://%s.service-now.com/api", string));
        }
        if (!configuration.hasOauthTokenUrl()) {
            configuration.setOauthTokenUrl(String.format("https://%s.service-now.com/oauth_token.do", string));
        }
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return new ServiceNowEndpoint(uri, this, configuration, string);
    }
}

