/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.velocity.VelocityEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.velocity.app.VelocityEngine;

@Component(value="velocity")
public class VelocityComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private VelocityEngine velocityEngine;

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        VelocityEndpoint answer = new VelocityEndpoint(uri, this, remaining);
        this.setProperties((Object)answer, parameters);
        answer.setContentCache(cache);
        answer.setVelocityEngine(this.velocityEngine);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }
}

