/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resilience.springboot;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.springboot.Resilience4jConfigurationDefinitionProperties;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.support.IntrospectionSupport;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"camel.resilience4j.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={Resilience4jConfigurationDefinitionProperties.class})
public class ResilienceAutoConfiguration {
    @Autowired
    private ConfigurableBeanFactory beanFactory;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private Resilience4jConfigurationDefinitionProperties config;

    @Bean(name={"resilience4j-configuration"})
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(name={"resilience4j-configuration"})
    public Resilience4jConfigurationDefinition defaultResilienceConfigurationDefinition() throws Exception {
        HashMap properties = new HashMap();
        IntrospectionSupport.getProperties((Object)this.config, properties, null, (boolean)false);
        Resilience4jConfigurationDefinition definition = new Resilience4jConfigurationDefinition();
        IntrospectionSupport.setProperties((CamelContext)this.camelContext, (TypeConverter)this.camelContext.getTypeConverter(), (Object)definition, properties);
        return definition;
    }

    @PostConstruct
    public void postConstruct() {
        if (this.beanFactory == null) {
            return;
        }
        HashMap properties = new HashMap();
        for (Map.Entry entry : this.config.getConfigurations().entrySet()) {
            properties.clear();
            IntrospectionSupport.getProperties(entry.getValue(), properties, null, (boolean)false);
            try {
                Resilience4jConfigurationDefinition definition = new Resilience4jConfigurationDefinition();
                IntrospectionSupport.setProperties((CamelContext)this.camelContext, (TypeConverter)this.camelContext.getTypeConverter(), (Object)definition, properties);
                this.beanFactory.registerSingleton((String)entry.getKey(), (Object)definition);
            }
            catch (Exception e) {
                throw new BeanCreationException((String)entry.getKey(), (Throwable)e);
            }
        }
    }
}

