/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.thrift.ThriftCompressionType;
import org.apache.camel.component.thrift.ThriftConfiguration;
import org.apache.camel.component.thrift.ThriftEndpoint;
import org.apache.camel.component.thrift.ThriftNegotiationType;
import org.apache.camel.component.thrift.ThriftUtils;
import org.apache.camel.component.thrift.server.ThriftHsHaServer;
import org.apache.camel.component.thrift.server.ThriftMethodHandler;
import org.apache.camel.component.thrift.server.ThriftThreadPoolServer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.thrift.transport.TZlibTransport;

public class ThriftConsumer
extends DefaultConsumer {
    private TNonblockingServerSocket asyncServerTransport;
    private TServerSocket syncServerTransport;
    private TServer server;
    private final ThriftConfiguration configuration;
    private final ThriftEndpoint endpoint;

    public ThriftConsumer(ThriftEndpoint endpoint, Processor processor, ThriftConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public ThriftConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.server == null) {
            this.log.debug("Starting the Thrift server");
            this.initializeServer();
            this.server.serve();
            this.log.info("Thrift server started and listening on port: {}", (Object)(this.asyncServerTransport == null ? this.syncServerTransport.getServerSocket().getLocalPort() : this.asyncServerTransport.getPort()));
        }
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.log.debug("Terminating Thrift server");
            this.server.stop();
            if (ObjectHelper.isNotEmpty((Object)this.asyncServerTransport)) {
                this.asyncServerTransport.close();
                this.asyncServerTransport = null;
            }
            if (ObjectHelper.isNotEmpty((Object)this.syncServerTransport)) {
                this.syncServerTransport.close();
                this.syncServerTransport = null;
            }
            this.server.stop();
            this.server = null;
        }
        super.doStop();
    }

    protected void initializeServer() throws TTransportException, IOException {
        Object args;
        Object serverProcessor;
        ProxyFactory serviceProxy = new ProxyFactory();
        ThriftMethodHandler methodHandler = new ThriftMethodHandler(this.endpoint, this);
        try {
            Class serverInterface = ThriftUtils.getServerInterface(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.endpoint.isSynchronous(), this.endpoint.getCamelContext());
            serviceProxy.setInterfaces(new Class[]{serverInterface});
            Class serverImplementationClass = serviceProxy.createClass();
            Object serverImplementationInstance = serverImplementationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ((Proxy)serverImplementationInstance).setHandler((MethodHandler)methodHandler);
            serverProcessor = ThriftUtils.constructServerProcessor(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), serverImplementationInstance, this.endpoint.isSynchronous(), this.endpoint.getCamelContext());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create server implementation proxy service for " + this.configuration.getService());
        }
        if (this.configuration.getNegotiationType() == ThriftNegotiationType.SSL && this.endpoint.isSynchronous()) {
            ClassResolver classResolver = this.endpoint.getCamelContext().getClassResolver();
            SSLContextParameters sslParameters = this.configuration.getSslParameters();
            if (sslParameters == null) {
                throw new IllegalArgumentException("SSL parameters must be initialized if negotiation type is set to " + (Object)((Object)this.configuration.getNegotiationType()));
            }
            ObjectHelper.notNull((Object)sslParameters.getSecureSocketProtocol(), (String)"Security protocol");
            ObjectHelper.notNull((Object)sslParameters.getKeyManagers().getKeyStore().getResource(), (String)"Keystore path");
            ObjectHelper.notNull((Object)sslParameters.getKeyManagers().getKeyStore().getPassword(), (String)"Keystore password");
            TSSLTransportFactory.TSSLTransportParameters sslParams = new TSSLTransportFactory.TSSLTransportParameters(sslParameters.getSecureSocketProtocol(), sslParameters.getCipherSuites() == null ? null : (String[])sslParameters.getCipherSuites().getCipherSuite().stream().toArray(String[]::new));
            if (ObjectHelper.isNotEmpty((Object)sslParameters.getKeyManagers().getKeyStore().getProvider()) && ObjectHelper.isNotEmpty((Object)sslParameters.getKeyManagers().getKeyStore().getType())) {
                sslParams.setKeyStore(ResourceHelper.resolveResourceAsInputStream((ClassResolver)classResolver, (String)sslParameters.getKeyManagers().getKeyStore().getResource()), sslParameters.getKeyManagers().getKeyStore().getPassword(), sslParameters.getKeyManagers().getKeyStore().getProvider(), sslParameters.getKeyManagers().getKeyStore().getType());
            } else {
                sslParams.setKeyStore(ResourceHelper.resolveResourceAsInputStream((ClassResolver)classResolver, (String)sslParameters.getKeyManagers().getKeyStore().getResource()), sslParameters.getKeyManagers().getKeyStore().getPassword());
            }
            try {
                this.syncServerTransport = TSSLTransportFactory.getServerSocket((int)this.configuration.getPort(), (int)this.configuration.getClientTimeout(), (InetAddress)InetAddress.getByName(this.configuration.getHost()), (TSSLTransportFactory.TSSLTransportParameters)sslParams);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown host defined: " + this.configuration.getHost());
            }
            ThriftThreadPoolServer.Args args2 = new ThriftThreadPoolServer.Args((TServerTransport)this.syncServerTransport);
            args2.processor((TProcessor)serverProcessor);
            args2.executorService(this.getEndpoint().getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, this.getEndpoint().getEndpointUri(), this.configuration.getPoolSize(), this.configuration.getMaxPoolSize()));
            args2.startThreadPool(this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "start-" + this.getEndpoint().getEndpointUri()));
            args2.context(this.endpoint.getCamelContext());
            this.server = new ThriftThreadPoolServer(args2);
        } else if (this.configuration.getCompressionType() == ThriftCompressionType.ZLIB && this.endpoint.isSynchronous()) {
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getPort())) {
                this.log.debug("Building sync Thrift server on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
                this.syncServerTransport = new TServerSocket(new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()), this.configuration.getClientTimeout());
            } else if (ObjectHelper.isEmpty((Object)this.configuration.getHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getPort())) {
                this.log.debug("Building sync Thrift server on <any address>:{}", (Object)this.configuration.getPort());
                this.syncServerTransport = new TServerSocket(this.configuration.getPort(), this.configuration.getClientTimeout());
            } else {
                throw new IllegalArgumentException("No server start properties (host, port) specified");
            }
            args = new ThriftThreadPoolServer.Args((TServerTransport)this.syncServerTransport);
            args.processor((TProcessor)serverProcessor);
            args.transportFactory((TTransportFactory)new TZlibTransport.Factory());
            args.executorService(this.getEndpoint().getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, this.getEndpoint().getEndpointUri(), this.configuration.getPoolSize(), this.configuration.getMaxPoolSize()));
            ((ThriftThreadPoolServer.Args)((Object)args)).startThreadPool(this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "start-" + this.getEndpoint().getEndpointUri()));
            ((ThriftThreadPoolServer.Args)((Object)args)).context(this.endpoint.getCamelContext());
            this.server = new ThriftThreadPoolServer((ThriftThreadPoolServer.Args)((Object)args));
        } else {
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getPort())) {
                this.log.debug("Building Thrift server on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
                this.asyncServerTransport = new TNonblockingServerSocket(new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()), this.configuration.getClientTimeout());
            } else if (ObjectHelper.isEmpty((Object)this.configuration.getHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getPort())) {
                this.log.debug("Building Thrift server on <any address>:{}", (Object)this.configuration.getPort());
                this.asyncServerTransport = new TNonblockingServerSocket(this.configuration.getPort(), this.configuration.getClientTimeout());
            } else {
                throw new IllegalArgumentException("No server start properties (host, port) specified");
            }
            args = new ThriftHsHaServer.Args((TNonblockingServerTransport)this.asyncServerTransport);
            args.processor((TProcessor)serverProcessor);
            args.executorService(this.getEndpoint().getCamelContext().getExecutorServiceManager().newThreadPool((Object)this, this.getEndpoint().getEndpointUri(), this.configuration.getPoolSize(), this.configuration.getMaxPoolSize()));
            ((ThriftHsHaServer.Args)((Object)args)).startThreadPool(this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "start-" + this.getEndpoint().getEndpointUri()));
            ((ThriftHsHaServer.Args)((Object)args)).context(this.endpoint.getCamelContext());
            this.server = new ThriftHsHaServer((ThriftHsHaServer.Args)((Object)args));
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.doSend(exchange, callback);
    }

    private boolean doSend(Exchange exchange, AsyncCallback callback) {
        if (this.isRunAllowed()) {
            this.getAsyncProcessor().process(exchange, doneSync -> {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
                callback.done(doneSync);
            });
            return false;
        }
        this.log.warn("Consumer not ready to process exchanges. The exchange {} will be discarded", (Object)exchange);
        callback.done(true);
        return true;
    }
}

