/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CamelSpringBootApplicationController {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootApplicationController.class);
    private final Main main;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean completed = new AtomicBoolean();

    public CamelSpringBootApplicationController(final ApplicationContext applicationContext, final CamelContext context) {
        this.main = new Main(){
            {
                this.camelContext = context;
            }

            protected ProducerTemplate findOrCreateCamelTemplate() {
                return (ProducerTemplate)applicationContext.getBean(ProducerTemplate.class);
            }

            protected CamelContext createCamelContext() {
                return context;
            }

            protected void initCamelContext() throws Exception {
            }

            protected void doStop() throws Exception {
                LOG.debug("Controller is shutting down CamelContext");
                try {
                    super.doStop();
                }
                finally {
                    this.completed.set(true);
                    CamelSpringBootApplicationController.this.latch.countDown();
                }
            }
        };
        this.main.configure().setRoutesCollectorEnabled(false);
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public AtomicBoolean getCompleted() {
        return this.completed;
    }

    public void run() {
        LOG.debug("Controller is starting and waiting for Spring-Boot to stop or JVM to terminate");
        try {
            this.main.run();
            LOG.debug("Waiting for CamelContext to complete shutdown");
            this.latch.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("CamelContext shutdown complete.");
    }

    @Deprecated
    public void blockMainThread() {
        this.run();
    }

    @PreDestroy
    private void destroy() {
        this.main.completed();
    }
}

