/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureTransform;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class XmlSignerConfiguration
extends XmlSignatureConfiguration {
    @UriParam(label="sign")
    private XPathFilterParameterSpec parentXpath;
    @UriParam(label="sign")
    private List<XPathFilterParameterSpec> xpathsToIdAttributes = Collections.emptyList();
    @UriParam(label="sign")
    private List<AlgorithmMethod> transformMethods = Collections.singletonList(XmlSignatureHelper.getCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
    private String transformMethodsName;
    @UriParam(label="sign")
    private KeyAccessor keyAccessor;
    private String keyAccessorName;
    @UriParam(label="sign", defaultValue="http://www.w3.org/TR/2001/REC-xml-c14n-20010315")
    private AlgorithmMethod canonicalizationMethod = new XmlSignatureTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    private String canonicalizationMethodName;
    @UriParam(label="sign", defaultValue="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")
    private String signatureAlgorithm = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    @UriParam(label="sign")
    private String digestAlgorithm;
    @UriParam(label="sign", defaultValue="true")
    private Boolean addKeyInfoReference = Boolean.TRUE;
    @UriParam(label="sign", defaultValue="ds")
    private String prefixForXmlSignatureNamespace = "ds";
    @UriParam(label="sign")
    private String contentObjectId;
    @UriParam(label="sign")
    private String signatureId;
    @UriParam(label="sign")
    private String contentReferenceUri;
    @UriParam(label="sign")
    private String contentReferenceType;
    @UriParam(label="sign")
    private String parentLocalName;
    @UriParam(label="sign")
    private String parentNamespace;
    @UriParam(label="sign", defaultValue="false")
    private Boolean plainText = Boolean.FALSE;
    @UriParam(label="sign", defaultValue="UTF-8")
    private String plainTextEncoding = "UTF-8";
    @UriParam(label="sign")
    private XmlSignatureProperties properties;
    private String propertiesName;

    public XmlSignerConfiguration copy() {
        try {
            return (XmlSignerConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        super.setCamelContext(camelContext);
        this.setTransformMethods(this.transformMethodsName);
        this.setCanonicalizationMethod(this.canonicalizationMethodName);
        this.setKeyAccessor(this.keyAccessorName);
        this.setProperties(this.propertiesName);
    }

    public KeyAccessor getKeyAccessor() {
        return this.keyAccessor;
    }

    public void setKeyAccessor(KeyAccessor keyAccessor) {
        this.keyAccessor = keyAccessor;
    }

    public void setKeyAccessor(String keyAccessorName) {
        KeyAccessor accessor;
        if (this.getCamelContext() != null && keyAccessorName != null && (accessor = (KeyAccessor)this.getCamelContext().getRegistry().lookupByNameAndType(keyAccessorName, KeyAccessor.class)) != null) {
            this.setKeyAccessor(accessor);
        }
        if (keyAccessorName != null) {
            this.keyAccessorName = keyAccessorName;
        }
    }

    public AlgorithmMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(AlgorithmMethod canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethodName) {
        AlgorithmMethod method;
        if (this.getCamelContext() != null && canonicalizationMethodName != null && (method = (AlgorithmMethod)this.getCamelContext().getRegistry().lookupByNameAndType(canonicalizationMethodName, AlgorithmMethod.class)) != null) {
            this.setCanonicalizationMethod(method);
        }
        if (canonicalizationMethodName != null) {
            this.canonicalizationMethodName = canonicalizationMethodName;
        }
    }

    public List<AlgorithmMethod> getTransformMethods() {
        return this.transformMethods;
    }

    public void setTransformMethods(List<AlgorithmMethod> transformMethods) {
        this.transformMethods = transformMethods;
    }

    public void setTransformMethods(String transformMethodsName) {
        List list;
        if (this.getCamelContext() != null && transformMethodsName != null && (list = (List)this.getCamelContext().getRegistry().lookupByNameAndType(transformMethodsName, List.class)) != null) {
            this.setTransformMethods(list);
        }
        if (transformMethodsName != null) {
            this.transformMethodsName = transformMethodsName;
        }
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public Boolean getAddKeyInfoReference() {
        return this.addKeyInfoReference;
    }

    public void setAddKeyInfoReference(Boolean addKeyInfoReference) {
        this.addKeyInfoReference = addKeyInfoReference;
    }

    public String getPrefixForXmlSignatureNamespace() {
        return this.prefixForXmlSignatureNamespace;
    }

    public void setPrefixForXmlSignatureNamespace(String prefixForXmlSignatureNamespace) {
        this.prefixForXmlSignatureNamespace = prefixForXmlSignatureNamespace;
    }

    public String getParentLocalName() {
        return this.parentLocalName;
    }

    public void setParentLocalName(String parentLocalName) {
        this.parentLocalName = parentLocalName;
    }

    public String getParentNamespace() {
        return this.parentNamespace;
    }

    public void setParentNamespace(String parentNamespace) {
        this.parentNamespace = parentNamespace;
    }

    public String getContentObjectId() {
        if (this.contentObjectId == null) {
            this.contentObjectId = "_" + UUID.randomUUID().toString();
        }
        return this.contentObjectId;
    }

    public void setContentObjectId(String contentObjectId) {
        this.contentObjectId = contentObjectId;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public void setSignatureId(String signatureId) {
        this.signatureId = signatureId;
    }

    public String getContentReferenceUri() {
        return this.contentReferenceUri;
    }

    public void setContentReferenceUri(String referenceUri) {
        this.contentReferenceUri = referenceUri;
    }

    public String getContentReferenceType() {
        return this.contentReferenceType;
    }

    public void setContentReferenceType(String referenceType) {
        this.contentReferenceType = referenceType;
    }

    public Boolean getPlainText() {
        return this.plainText;
    }

    public void setPlainText(Boolean plainText) {
        this.plainText = plainText;
    }

    public String getPlainTextEncoding() {
        return this.plainTextEncoding;
    }

    public void setPlainTextEncoding(String plainTextEncoding) {
        this.plainTextEncoding = plainTextEncoding;
    }

    public XmlSignatureProperties getProperties() {
        return this.properties;
    }

    public void setProperties(XmlSignatureProperties properties) {
        this.properties = properties;
    }

    public void setProperties(String propertiesName) {
        XmlSignatureProperties props;
        if (this.getCamelContext() != null && propertiesName != null && (props = (XmlSignatureProperties)this.getCamelContext().getRegistry().lookupByNameAndType(propertiesName, XmlSignatureProperties.class)) != null) {
            this.setProperties(props);
        }
        if (propertiesName != null) {
            this.propertiesName = propertiesName;
        }
    }

    public String getKeyAccessorName() {
        return this.keyAccessorName;
    }

    public void setKeyAccessorName(String keyAccessorName) {
        this.keyAccessorName = keyAccessorName;
    }

    public String getCanonicalizationMethodName() {
        return this.canonicalizationMethodName;
    }

    public void setCanonicalizationMethodName(String canonicalizationMethodName) {
        this.canonicalizationMethodName = canonicalizationMethodName;
    }

    public String getTransformMethodsName() {
        return this.transformMethodsName;
    }

    public void setTransformMethodsName(String transformMethodsName) {
        this.transformMethodsName = transformMethodsName;
    }

    public String getPropertiesName() {
        return this.propertiesName;
    }

    public void setPropertiesName(String propertiesName) {
        this.propertiesName = propertiesName;
    }

    public List<XPathFilterParameterSpec> getXpathsToIdAttributes() {
        return this.xpathsToIdAttributes;
    }

    public void setXpathsToIdAttributes(List<XPathFilterParameterSpec> xpathsToIdAttributes) {
        this.xpathsToIdAttributes = xpathsToIdAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(xpathsToIdAttributes);
    }

    public XPathFilterParameterSpec getParentXpath() {
        return this.parentXpath;
    }

    public void setParentXpath(XPathFilterParameterSpec parentXpath) {
        this.parentXpath = parentXpath;
    }
}

