/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.verifier;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoSecurityException;
import com.mongodb.MongoTimeoutException;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.mongodb.conf.ConnectionParamsConfiguration;
import org.apache.camel.util.CastUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Logger LOG = LoggerFactory.getLogger(MongoComponentVerifierExtension.class);
    private static final int CONNECTION_TIMEOUT = 2000;

    public MongoComponentVerifierExtension() {
        super("mongodb");
    }

    public ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"host", parameters)).error(ResultErrorHelper.requiresOption((String)"user", parameters)).error(ResultErrorHelper.requiresOption((String)"password", parameters));
        return builder.build();
    }

    public ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        ConnectionParamsConfiguration mongoConf = new ConnectionParamsConfiguration(CastUtils.cast(parameters));
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder();
        optionsBuilder.connectTimeout(2000);
        optionsBuilder.serverSelectionTimeout(2000);
        optionsBuilder.maxWaitTime(2000);
        MongoClientURI connectionURI = new MongoClientURI(mongoConf.getMongoClientURI(), optionsBuilder);
        LOG.info("Testing connection against {}", (Object)connectionURI);
        try (MongoClient mongoClient = new MongoClient(connectionURI);){
            mongoClient.getDatabase(connectionURI.getDatabase()).runCommand((Bson)Document.parse((String)"{ ping: 1 }"));
            LOG.info("Testing connection successful!");
        }
        catch (MongoSecurityException e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)String.format("Unable to authenticate %s against %s authentication database!", mongoConf.getUser(), mongoConf.getAdminDB()));
            builder.error(errorBuilder.build());
        }
        catch (MongoTimeoutException e) {
            String description;
            ComponentVerifierExtension.VerificationError.StandardCode code = ComponentVerifierExtension.VerificationError.StandardCode.GENERIC;
            if (e.getMessage().contains("com.mongodb.MongoSecurityException")) {
                code = ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION;
                description = String.format("Unable to authenticate %s against %s authentication database!", mongoConf.getUser(), mongoConf.getAdminDB());
            } else {
                description = e.getMessage().contains("com.mongodb.MongoSocket") && e.getMessage().contains("Exception") ? String.format("Unable to connect to %s!", mongoConf.getHost()) : String.format("Generic exception while connecting to %s!", mongoConf.getHost());
            }
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)code, (String)String.format(description, new Object[0]));
            builder.error(errorBuilder.build());
        }
    }
}

