/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MongoDbConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,mongodb";
    @UriParam(label="consumer,mongodb", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbPassword;
    @UriParam(label="consumer,mongodb", defaultValue="1")
    private int initialSyncMaxThreads = 1;
    @UriParam(label="consumer,mongodb", defaultValue="0")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,mongodb")
    private String collectionBlacklist;
    @UriParam(label="consumer,mongodb")
    private String collectionWhitelist;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslEnabled = false;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,mongodb", defaultValue="true")
    private boolean mongodbMembersAutoDiscover = true;
    @UriParam(label="consumer,mongodb")
    private String fieldRenames;
    @UriParam(label="consumer,mongodb", defaultValue="500")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,mongodb", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,mongodb")
    private String databaseWhitelist;
    @UriParam(label="consumer,mongodb")
    private String mongodbHosts;
    @UriParam(label="consumer,mongodb", defaultValue="1000")
    private long connectBackoffInitialDelayMs = 1000L;
    @UriParam(label="consumer,mongodb")
    private int snapshotFetchSize;
    @UriParam(label="consumer,mongodb")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,mongodb", defaultValue="16")
    private int connectMaxAttempts = 16;
    @UriParam(label="consumer,mongodb")
    private String mongodbUser;
    @UriParam(label="consumer,mongodb")
    private String fieldBlacklist;
    @UriParam(label="consumer,mongodb", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,mongodb", defaultValue="0")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,mongodb")
    @Metadata(required=true)
    private String mongodbName;
    @UriParam(label="consumer,mongodb", defaultValue="120000")
    private long connectBackoffMaxDelayMs = 120000L;
    @UriParam(label="consumer,mongodb", defaultValue="false")
    private boolean mongodbSslInvalidHostnameAllowed = false;
    @UriParam(label="consumer,mongodb")
    private String databaseBlacklist;
    @UriParam(label="consumer,mongodb", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,mongodb", defaultValue="initial")
    private String snapshotMode = "initial";

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMongodbPassword(String mongodbPassword) {
        this.mongodbPassword = mongodbPassword;
    }

    public String getMongodbPassword() {
        return this.mongodbPassword;
    }

    public void setInitialSyncMaxThreads(int initialSyncMaxThreads) {
        this.initialSyncMaxThreads = initialSyncMaxThreads;
    }

    public int getInitialSyncMaxThreads() {
        return this.initialSyncMaxThreads;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setCollectionBlacklist(String collectionBlacklist) {
        this.collectionBlacklist = collectionBlacklist;
    }

    public String getCollectionBlacklist() {
        return this.collectionBlacklist;
    }

    public void setCollectionWhitelist(String collectionWhitelist) {
        this.collectionWhitelist = collectionWhitelist;
    }

    public String getCollectionWhitelist() {
        return this.collectionWhitelist;
    }

    public void setMongodbSslEnabled(boolean mongodbSslEnabled) {
        this.mongodbSslEnabled = mongodbSslEnabled;
    }

    public boolean getMongodbSslEnabled() {
        return this.mongodbSslEnabled;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean getTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setMongodbMembersAutoDiscover(boolean mongodbMembersAutoDiscover) {
        this.mongodbMembersAutoDiscover = mongodbMembersAutoDiscover;
    }

    public boolean getMongodbMembersAutoDiscover() {
        return this.mongodbMembersAutoDiscover;
    }

    public void setFieldRenames(String fieldRenames) {
        this.fieldRenames = fieldRenames;
    }

    public String getFieldRenames() {
        return this.fieldRenames;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setDatabaseWhitelist(String databaseWhitelist) {
        this.databaseWhitelist = databaseWhitelist;
    }

    public String getDatabaseWhitelist() {
        return this.databaseWhitelist;
    }

    public void setMongodbHosts(String mongodbHosts) {
        this.mongodbHosts = mongodbHosts;
    }

    public String getMongodbHosts() {
        return this.mongodbHosts;
    }

    public void setConnectBackoffInitialDelayMs(long connectBackoffInitialDelayMs) {
        this.connectBackoffInitialDelayMs = connectBackoffInitialDelayMs;
    }

    public long getConnectBackoffInitialDelayMs() {
        return this.connectBackoffInitialDelayMs;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setConnectMaxAttempts(int connectMaxAttempts) {
        this.connectMaxAttempts = connectMaxAttempts;
    }

    public int getConnectMaxAttempts() {
        return this.connectMaxAttempts;
    }

    public void setMongodbUser(String mongodbUser) {
        this.mongodbUser = mongodbUser;
    }

    public String getMongodbUser() {
        return this.mongodbUser;
    }

    public void setFieldBlacklist(String fieldBlacklist) {
        this.fieldBlacklist = fieldBlacklist;
    }

    public String getFieldBlacklist() {
        return this.fieldBlacklist;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setMongodbName(String mongodbName) {
        this.mongodbName = mongodbName;
    }

    public String getMongodbName() {
        return this.mongodbName;
    }

    public void setConnectBackoffMaxDelayMs(long connectBackoffMaxDelayMs) {
        this.connectBackoffMaxDelayMs = connectBackoffMaxDelayMs;
    }

    public long getConnectBackoffMaxDelayMs() {
        return this.connectBackoffMaxDelayMs;
    }

    public void setMongodbSslInvalidHostnameAllowed(boolean mongodbSslInvalidHostnameAllowed) {
        this.mongodbSslInvalidHostnameAllowed = mongodbSslInvalidHostnameAllowed;
    }

    public boolean getMongodbSslInvalidHostnameAllowed() {
        return this.mongodbSslInvalidHostnameAllowed;
    }

    public void setDatabaseBlacklist(String databaseBlacklist) {
        this.databaseBlacklist = databaseBlacklist;
    }

    public String getDatabaseBlacklist() {
        return this.databaseBlacklist;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    @Override
    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size", Integer.valueOf(this.maxQueueSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.password", this.mongodbPassword);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "initial.sync.max.threads", Integer.valueOf(this.initialSyncMaxThreads));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.delay.ms", Long.valueOf(this.snapshotDelayMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "collection.blacklist", this.collectionBlacklist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "collection.whitelist", this.collectionWhitelist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.ssl.enabled", Boolean.valueOf(this.mongodbSslEnabled));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "tombstones.on.delete", Boolean.valueOf(this.tombstonesOnDelete));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.members.auto.discover", Boolean.valueOf(this.mongodbMembersAutoDiscover));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "field.renames", this.fieldRenames);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "poll.interval.ms", Long.valueOf(this.pollIntervalMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.topics.prefix", this.heartbeatTopicsPrefix);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.whitelist", this.databaseWhitelist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.hosts", this.mongodbHosts);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "connect.backoff.initial.delay.ms", Long.valueOf(this.connectBackoffInitialDelayMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.fetch.size", Integer.valueOf(this.snapshotFetchSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.history.file.filename", this.databaseHistoryFileFilename);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "connect.max.attempts", Integer.valueOf(this.connectMaxAttempts));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.user", this.mongodbUser);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "field.blacklist", this.fieldBlacklist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "source.struct.version", this.sourceStructVersion);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.interval.ms", Integer.valueOf(this.heartbeatIntervalMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.name", this.mongodbName);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "connect.backoff.max.delay.ms", Long.valueOf(this.connectBackoffMaxDelayMs));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "mongodb.ssl.invalid.hostname.allowed", Boolean.valueOf(this.mongodbSslInvalidHostnameAllowed));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.blacklist", this.databaseBlacklist);
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.batch.size", Integer.valueOf(this.maxBatchSize));
        MongoDbConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode", this.snapshotMode);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return MongoDbConnector.class;
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.mongodbPassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'mongodbPassword' must be set.");
        }
        if (MongoDbConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.mongodbName)) {
            return ConfigurationValidation.notValid((String)"Required field 'mongodbName' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    @Override
    public String getConnectorDatabaseType() {
        return "mongodb";
    }
}

