/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.kinesis.KinesisEndpoint;
import org.apache.camel.support.DefaultProducer;

public class KinesisProducer
extends DefaultProducer {
    public KinesisProducer(KinesisEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KinesisEndpoint getEndpoint() {
        return (KinesisEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PutRecordRequest request = this.createRequest(exchange);
        PutRecordResult putRecordResult = this.getEndpoint().getClient().putRecord(request);
        Message message = KinesisProducer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsKinesisSequenceNumber", (Object)putRecordResult.getSequenceNumber());
        message.setHeader("CamelAwsKinesisShardId", (Object)putRecordResult.getShardId());
    }

    private PutRecordRequest createRequest(Exchange exchange) {
        ByteBuffer body = (ByteBuffer)exchange.getIn().getBody(ByteBuffer.class);
        Object partitionKey = exchange.getIn().getHeader("CamelAwsKinesisPartitionKey");
        Object sequenceNumber = exchange.getIn().getHeader("CamelAwsKinesisSequenceNumber");
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setData(body);
        putRecordRequest.setStreamName(this.getEndpoint().getConfiguration().getStreamName());
        putRecordRequest.setPartitionKey(partitionKey.toString());
        if (sequenceNumber != null) {
            putRecordRequest.setSequenceNumberForOrdering(sequenceNumber.toString());
        }
        return putRecordRequest;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

