/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.validator;

import org.apache.camel.CamelContext;
import org.apache.camel.model.validator.CustomValidatorDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.reifier.validator.ValidatorReifier;
import org.apache.camel.spi.Validator;

public class CustomValidatorReifier
extends ValidatorReifier<CustomValidatorDefinition> {
    public CustomValidatorReifier(ValidatorDefinition definition) {
        super((CustomValidatorDefinition)definition);
    }

    @Override
    protected Validator doCreateValidator(CamelContext context) throws Exception {
        Validator validator;
        if (((CustomValidatorDefinition)this.definition).getRef() == null && ((CustomValidatorDefinition)this.definition).getClassName() == null) {
            throw new IllegalArgumentException("'ref' or 'type' must be specified for customValidator");
        }
        if (((CustomValidatorDefinition)this.definition).getRef() != null) {
            validator = (Validator)context.getRegistry().lookupByNameAndType(((CustomValidatorDefinition)this.definition).getRef(), Validator.class);
            if (validator == null) {
                throw new IllegalArgumentException("Cannot find validator with ref:" + ((CustomValidatorDefinition)this.definition).getRef());
            }
            if (validator.getType() != null) {
                throw new IllegalArgumentException(String.format("Validator '%s' is already in use. Please check if duplicate validator exists.", ((CustomValidatorDefinition)this.definition).getRef()));
            }
        } else {
            Class validatorClass = context.getClassResolver().resolveMandatoryClass(((CustomValidatorDefinition)this.definition).getClassName(), Validator.class);
            if (validatorClass == null) {
                throw new IllegalArgumentException("Cannot find validator class: " + ((CustomValidatorDefinition)this.definition).getClassName());
            }
            validator = (Validator)context.getInjector().newInstance(validatorClass, false);
        }
        validator.setCamelContext(context);
        return validator.setType(((CustomValidatorDefinition)this.definition).getType());
    }
}

