/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.CryptoDataFormat;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class CryptoDataFormatReifier
extends DataFormatReifier<CryptoDataFormat> {
    public CryptoDataFormatReifier(DataFormatDefinition definition) {
        super((CryptoDataFormat)definition);
    }

    @Override
    protected DataFormat doCreateDataFormat(CamelContext camelContext) {
        DataFormat cryptoFormat = super.doCreateDataFormat(camelContext);
        if (ObjectHelper.isNotEmpty((Object)((CryptoDataFormat)this.definition).getKeyRef())) {
            Key key = (Key)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((CryptoDataFormat)this.definition).getKeyRef(), Key.class);
            this.setProperty(camelContext, cryptoFormat, "key", key);
        }
        if (ObjectHelper.isNotEmpty((Object)((CryptoDataFormat)this.definition).getAlgorithmParameterRef())) {
            AlgorithmParameterSpec spec = (AlgorithmParameterSpec)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((CryptoDataFormat)this.definition).getAlgorithmParameterRef(), AlgorithmParameterSpec.class);
            this.setProperty(camelContext, cryptoFormat, "AlgorithmParameterSpec", spec);
        }
        if (ObjectHelper.isNotEmpty((Object)((CryptoDataFormat)this.definition).getInitVectorRef())) {
            byte[] iv = (byte[])CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)((CryptoDataFormat)this.definition).getInitVectorRef(), byte[].class);
            this.setProperty(camelContext, cryptoFormat, "InitializationVector", iv);
        }
        return cryptoFormat;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        Boolean answer = ObjectHelper.toBoolean((Object)((CryptoDataFormat)this.definition).getShouldAppendHMAC());
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(camelContext, dataFormat, "shouldAppendHMAC", Boolean.FALSE);
        } else {
            this.setProperty(camelContext, dataFormat, "shouldAppendHMAC", Boolean.TRUE);
        }
        answer = ObjectHelper.toBoolean((Object)((CryptoDataFormat)this.definition).getInline());
        if (answer != null && answer.booleanValue()) {
            this.setProperty(camelContext, dataFormat, "shouldInlineInitializationVector", Boolean.TRUE);
        } else {
            this.setProperty(camelContext, dataFormat, "shouldInlineInitializationVector", Boolean.FALSE);
        }
        if (((CryptoDataFormat)this.definition).getAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "algorithm", ((CryptoDataFormat)this.definition).getAlgorithm());
        }
        if (((CryptoDataFormat)this.definition).getCryptoProvider() != null) {
            this.setProperty(camelContext, dataFormat, "cryptoProvider", ((CryptoDataFormat)this.definition).getCryptoProvider());
        }
        if (((CryptoDataFormat)this.definition).getMacAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "macAlgorithm", ((CryptoDataFormat)this.definition).getMacAlgorithm());
        }
        if (((CryptoDataFormat)this.definition).getBuffersize() != null) {
            this.setProperty(camelContext, dataFormat, "buffersize", ((CryptoDataFormat)this.definition).getBuffersize());
        }
    }
}

