/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.config.BatchResequencerConfig;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.StreamResequencer;
import org.apache.camel.processor.resequencer.DefaultExchangeComparator;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class ResequenceReifier
extends ProcessorReifier<ResequenceDefinition> {
    public ResequenceReifier(ProcessorDefinition<?> definition) {
        super((ResequenceDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (((ResequenceDefinition)this.definition).getResequencerConfig() != null) {
            if (((ResequenceDefinition)this.definition).getResequencerConfig() instanceof StreamResequencerConfig) {
                ((ResequenceDefinition)this.definition).setStreamConfig((StreamResequencerConfig)((ResequenceDefinition)this.definition).getResequencerConfig());
            } else {
                ((ResequenceDefinition)this.definition).setBatchConfig((BatchResequencerConfig)((ResequenceDefinition)this.definition).getResequencerConfig());
            }
        }
        if (((ResequenceDefinition)this.definition).getStreamConfig() != null) {
            return this.createStreamResequencer(routeContext, ((ResequenceDefinition)this.definition).getStreamConfig());
        }
        if (((ResequenceDefinition)this.definition).getBatchConfig() == null) {
            ((ResequenceDefinition)this.definition).batch();
        }
        return this.createBatchResequencer(routeContext, ((ResequenceDefinition)this.definition).getBatchConfig());
    }

    protected Resequencer createBatchResequencer(RouteContext routeContext, BatchResequencerConfig config) throws Exception {
        Processor processor = this.createChildProcessor(routeContext, true);
        Expression expression = ((ResequenceDefinition)this.definition).getExpression().createExpression(routeContext);
        CamelInternalProcessor internal = new CamelInternalProcessor(processor);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        ObjectHelper.notNull((Object)config, (String)"config", (Object)this);
        ObjectHelper.notNull((Object)expression, (String)"expression", (Object)this);
        boolean isReverse = config.getReverse() != null && config.getReverse() != false;
        boolean isAllowDuplicates = config.getAllowDuplicates() != null && config.getAllowDuplicates() != false;
        Resequencer resequencer = new Resequencer(routeContext.getCamelContext(), (Processor)internal, expression, isAllowDuplicates, isReverse);
        resequencer.setBatchSize(config.getBatchSize());
        resequencer.setBatchTimeout(config.getBatchTimeout());
        resequencer.setReverse(isReverse);
        resequencer.setAllowDuplicates(isAllowDuplicates);
        if (config.getIgnoreInvalidExchanges() != null) {
            resequencer.setIgnoreInvalidExchanges(config.getIgnoreInvalidExchanges().booleanValue());
        }
        return resequencer;
    }

    protected StreamResequencer createStreamResequencer(RouteContext routeContext, StreamResequencerConfig config) throws Exception {
        ExpressionResultComparator comparator;
        Processor processor = this.createChildProcessor(routeContext, true);
        Expression expression = ((ResequenceDefinition)this.definition).getExpression().createExpression(routeContext);
        CamelInternalProcessor internal = new CamelInternalProcessor(processor);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice(routeContext));
        ObjectHelper.notNull((Object)config, (String)"config", (Object)this);
        ObjectHelper.notNull((Object)expression, (String)"expression", (Object)this);
        if (config.getComparatorRef() != null) {
            comparator = (ExpressionResultComparator)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)config.getComparatorRef(), ExpressionResultComparator.class);
        } else {
            comparator = config.getComparator();
            if (comparator == null) {
                comparator = new DefaultExchangeComparator();
            }
        }
        comparator.setExpression(expression);
        StreamResequencer resequencer = new StreamResequencer(routeContext.getCamelContext(), (Processor)internal, (SequenceElementComparator)comparator, expression);
        resequencer.setTimeout(config.getTimeout());
        if (config.getDeliveryAttemptInterval() != null) {
            resequencer.setDeliveryAttemptInterval(config.getDeliveryAttemptInterval().longValue());
        }
        resequencer.setCapacity(config.getCapacity());
        resequencer.setRejectOld(config.getRejectOld());
        if (config.getIgnoreInvalidExchanges() != null) {
            resequencer.setIgnoreInvalidExchanges(config.getIgnoreInvalidExchanges().booleanValue());
        }
        return resequencer;
    }
}

