/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.Processor;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;

public class ConvertBodyReifier
extends ProcessorReifier<ConvertBodyDefinition> {
    public ConvertBodyReifier(ProcessorDefinition<?> definition) {
        super((ProcessorDefinition)ConvertBodyDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (((ConvertBodyDefinition)this.definition).getTypeClass() == null && ((ConvertBodyDefinition)this.definition).getType() != null) {
            ((ConvertBodyDefinition)this.definition).setTypeClass(routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(((ConvertBodyDefinition)this.definition).getType()));
        }
        if (((ConvertBodyDefinition)this.definition).getCharset() != null) {
            ConvertBodyReifier.validateCharset(((ConvertBodyDefinition)this.definition).getCharset());
        }
        return new ConvertBodyProcessor(((ConvertBodyDefinition)this.definition).getTypeClass(), ((ConvertBodyDefinition)this.definition).getCharset());
    }

    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null && Charset.isSupported(charset)) {
            Charset.forName(charset);
            return;
        }
        throw new UnsupportedCharsetException(charset);
    }
}

